/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.zone;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.TimeZone;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PDTConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDTConfig.class);
    private static ZoneId s_aDefaultZoneId = TimeZone.getDefault().toZoneId();
    private static final PDTConfig INSTANCE = new PDTConfig();

    private PDTConfig() {
    }

    public static @NonNull ESuccess setDefaultDateTimeZoneID(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DateTimeZoneID");
        try {
            ZoneId zoneId = ZoneId.of(string);
            TimeZone timeZone = TimeZone.getTimeZone(zoneId);
            s_aDefaultZoneId = zoneId;
            TimeZone.setDefault(timeZone);
            return ESuccess.SUCCESS;
        }
        catch (DateTimeException dateTimeException) {
            LOGGER.warn("Unsupported ZoneId '" + string + "'", (Throwable)dateTimeException);
            return ESuccess.FAILURE;
        }
    }

    public static @NonNull ZoneId getDefaultZoneId() {
        return s_aDefaultZoneId;
    }

    public static @NonNull ZoneId getUTCZoneId() {
        return ZoneOffset.UTC;
    }

    public static @NonNull TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }

    public static @NonNull TimeZone getUTCTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }
}

