/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.util;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.numeric.MathHelper;
import com.helger.collection.commons.CommonsArrayList;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.jspecify.annotations.NonNull;

@Immutable
public final class PDTDisplayHelper {
    private static final PDTDisplayHelper INSTANCE = new PDTDisplayHelper();

    private PDTDisplayHelper() {
    }

    @Nonempty
    public static @NonNull String getPeriodText(int n, int n2, int n3, long l, long l2, long l3, @NonNull IPeriodTextProvider iPeriodTextProvider) {
        String string = iPeriodTextProvider.getYears(n);
        String string2 = iPeriodTextProvider.getMonths(n2);
        String string3 = iPeriodTextProvider.getDays(n3);
        String string4 = iPeriodTextProvider.getHours(l);
        String string5 = iPeriodTextProvider.getMinutes(l2);
        String string6 = iPeriodTextProvider.getSeconds(l3);
        CommonsArrayList commonsArrayList = new CommonsArrayList(6);
        if (n != 0) {
            commonsArrayList.add((Object)string);
        }
        if (n2 != 0 || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string2);
        }
        if (n3 != 0 || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string3);
        }
        if (l != 0L || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string4);
        }
        if (l2 != 0L || commonsArrayList.isNotEmpty()) {
            commonsArrayList.add((Object)string5);
        }
        commonsArrayList.add((Object)string6);
        int n4 = commonsArrayList.size();
        if (n4 == 1) {
            return (String)commonsArrayList.get(0);
        }
        if (n4 == 2) {
            return (String)commonsArrayList.get(0) + iPeriodTextProvider.getAnd() + (String)commonsArrayList.get(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n4 - 1; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(iPeriodTextProvider.getComma());
            }
            stringBuilder.append((String)commonsArrayList.get(i));
        }
        return stringBuilder.append(iPeriodTextProvider.getAnd()).append((String)commonsArrayList.getLastOrNull()).toString();
    }

    @Nonempty
    public static @NonNull String getPeriodText(@NonNull LocalDateTime localDateTime, @NonNull LocalDateTime localDateTime2, @NonNull IPeriodTextProvider iPeriodTextProvider) {
        LocalDate localDate = localDateTime.toLocalDate();
        LocalDate localDate2 = localDateTime2.toLocalDate();
        Duration duration = Duration.between(localDateTime.toLocalTime(), localDateTime2.toLocalTime());
        long l = duration.getSeconds();
        if (l < 0L && localDate2.isAfter(localDate)) {
            localDate2 = localDate2.minusDays(1L);
            l += 86400L;
        }
        Period period = Period.between(localDate, localDate2);
        int n = period.getYears();
        int n2 = period.getMonths();
        int n3 = period.getDays();
        long l2 = l / 3600L;
        long l3 = (l -= l2 * 3600L) / 60L;
        return PDTDisplayHelper.getPeriodText(n, n2, n3, l2, l3, l -= l3 * 60L, iPeriodTextProvider);
    }

    @Nonempty
    public static @NonNull String getPeriodTextDE(@NonNull LocalDateTime localDateTime, @NonNull LocalDateTime localDateTime2) {
        return PDTDisplayHelper.getPeriodText(localDateTime, localDateTime2, IPeriodTextProvider.DE);
    }

    @Nonempty
    public static @NonNull String getPeriodTextEN(@NonNull LocalDateTime localDateTime, @NonNull LocalDateTime localDateTime2) {
        return PDTDisplayHelper.getPeriodText(localDateTime, localDateTime2, IPeriodTextProvider.EN);
    }

    public static interface IPeriodTextProvider {
        public static final IPeriodTextProvider EN = new IPeriodTextProvider(){};
        public static final IPeriodTextProvider DE = new IPeriodTextProvider(){

            @Override
            @Nonempty
            public @NonNull String getYears(@CheckForSigned int n) {
                return MathHelper.abs((int)n) == 1 ? n + " Jahr" : n + " Jahre";
            }

            @Override
            @Nonempty
            public @NonNull String getMonths(@CheckForSigned int n) {
                return MathHelper.abs((int)n) == 1 ? n + " Monat" : n + " Monate";
            }

            @Override
            @Nonempty
            public @NonNull String getDays(@CheckForSigned int n) {
                return MathHelper.abs((int)n) == 1 ? n + " Tag" : n + " Tage";
            }

            @Override
            @Nonempty
            public @NonNull String getHours(@CheckForSigned long l) {
                return MathHelper.abs((long)l) == 1L ? l + " Stunde" : l + " Stunden";
            }

            @Override
            @Nonempty
            public @NonNull String getMinutes(@CheckForSigned long l) {
                return MathHelper.abs((long)l) == 1L ? l + " Minute" : l + " Minuten";
            }

            @Override
            @Nonempty
            public @NonNull String getSeconds(@CheckForSigned long l) {
                return MathHelper.abs((long)l) == 1L ? l + " Sekunde" : l + " Sekunden";
            }

            @Override
            public @NonNull String getAnd() {
                return " und ";
            }
        };

        @Nonempty
        default public @NonNull String getYears(@CheckForSigned int n) {
            return MathHelper.abs((int)n) == 1 ? n + " year" : n + " years";
        }

        @Nonempty
        default public @NonNull String getMonths(@CheckForSigned int n) {
            return MathHelper.abs((int)n) == 1 ? n + " month" : n + " months";
        }

        @Nonempty
        default public @NonNull String getDays(@CheckForSigned int n) {
            return MathHelper.abs((int)n) == 1 ? n + " day" : n + " days";
        }

        @Nonempty
        default public @NonNull String getHours(@CheckForSigned long l) {
            return MathHelper.abs((long)l) == 1L ? l + " hour" : l + " hours";
        }

        @Nonempty
        default public @NonNull String getMinutes(@CheckForSigned long l) {
            return MathHelper.abs((long)l) == 1L ? l + " minute" : l + " minutes";
        }

        @Nonempty
        default public @NonNull String getSeconds(@CheckForSigned long l) {
            return MathHelper.abs((long)l) == 1L ? l + " second" : l + " seconds";
        }

        default public @NonNull String getAnd() {
            return " and ";
        }

        default public @NonNull String getComma() {
            return ", ";
        }
    }
}

