/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.helper;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import com.helger.datetime.zone.PDTConfig;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class PDTFactory {
    private PDTFactory() {
    }

    private static @NonNull ZoneId _getZoneId() {
        return PDTConfig.getDefaultZoneId();
    }

    public static int getTimezoneOffsetInMinutes(@NonNull Date date) {
        return -date.getTimezoneOffset();
    }

    public static int getTimezoneOffsetInMinutes(@NonNull GregorianCalendar gregorianCalendar) {
        long l = gregorianCalendar.getTimeZone().getRawOffset();
        return Math.toIntExact(l / 60000L);
    }

    public static int getTimezoneOffsetInMinutes(@NonNull ZoneId zoneId, @NonNull Instant instant) {
        ZoneOffset zoneOffset = zoneId.getRules().getStandardOffset(instant);
        return PDTFactory.getTimezoneOffsetInMinutes(zoneOffset);
    }

    public static int getTimezoneOffsetInMinutes(@NonNull ZoneOffset zoneOffset) {
        return zoneOffset.getTotalSeconds() / 60;
    }

    public static @NonNull ZoneOffset getZoneOffsetFromOffsetInMinutes(int n) {
        return ZoneOffset.ofHoursMinutes(n / 60, n % 60);
    }

    public static @NonNull ZoneOffset getZoneOffset(@NonNull Date date) {
        int n = PDTFactory.getTimezoneOffsetInMinutes(date);
        return PDTFactory.getZoneOffsetFromOffsetInMinutes(n);
    }

    public static @NonNull ZoneId getZoneIdFromOffsetInMinutes(int n) {
        ZoneOffset zoneOffset = PDTFactory.getZoneOffsetFromOffsetInMinutes(n);
        return ZoneId.ofOffset("", zoneOffset);
    }

    public static @NonNull ZoneId getZoneId(@NonNull Date date) {
        int n = PDTFactory.getTimezoneOffsetInMinutes(date);
        return PDTFactory.getZoneIdFromOffsetInMinutes(n);
    }

    public static @NonNull TimeZone getTimeZone(@NonNull Date date) {
        ZoneId zoneId = PDTFactory.getZoneId(date);
        return TimeZone.getTimeZone(zoneId);
    }

    public static @NonNull ZonedDateTime getCurrentZonedDateTime() {
        return ZonedDateTime.now(PDTFactory._getZoneId());
    }

    public static @NonNull ZonedDateTime getCurrentZonedDateTimeUTC() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    public static @Nullable ZonedDateTime getWithMillisOnly(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.truncatedTo(ChronoUnit.MILLIS);
    }

    @Nonnegative
    public static ZonedDateTime getCurrentZonedDateTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentZonedDateTime());
    }

    @Nonnegative
    public static ZonedDateTime getCurrentZonedDateTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentZonedDateTimeUTC());
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toZonedDateTime();
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : ZonedDateTime.of(localDateTime, PDTFactory._getZoneId());
    }

    public static @Nullable ZonedDateTime createZonedDateTimeUTC(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : ZonedDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable LocalDate localDate) {
        return localDate == null ? null : ZonedDateTime.of(localDate.atStartOfDay(), PDTFactory._getZoneId());
    }

    public static @Nullable ZonedDateTime createZonedDateTimeUTC(@Nullable LocalDate localDate) {
        return localDate == null ? null : ZonedDateTime.of(localDate.atStartOfDay(), ZoneOffset.UTC);
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : ZonedDateTime.of(offsetDate.toLocalDate().atStartOfDay(), offsetDate.getOffset());
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable XMLOffsetDate xMLOffsetDate) {
        return xMLOffsetDate == null ? null : ZonedDateTime.of(xMLOffsetDate.toLocalDate().atStartOfDay(), xMLOffsetDate.hasOffset() ? xMLOffsetDate.getOffset() : PDTFactory._getZoneId());
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(yearMonth));
    }

    public static @Nullable ZonedDateTime createZonedDateTimeUTC(@Nullable YearMonth yearMonth) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(yearMonth));
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable Year year) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(year));
    }

    public static @Nullable ZonedDateTime createZonedDateTimeUTC(@Nullable Year year) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(year));
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : ZonedDateTime.of(PDTFactory._toLocalDateTime(localTime), PDTFactory._getZoneId());
    }

    public static @Nullable ZonedDateTime createZonedDateTimeUTC(@Nullable LocalTime localTime) {
        return localTime == null ? null : ZonedDateTime.of(PDTFactory._toLocalDateTime(localTime), ZoneOffset.UTC);
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable OffsetTime offsetTime) {
        return PDTFactory.createZonedDateTime(PDTFactory.createOffsetDateTime(offsetTime));
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable XMLOffsetTime xMLOffsetTime) {
        return PDTFactory.createZonedDateTime(PDTFactory.createOffsetDateTime(xMLOffsetTime));
    }

    public static @NonNull ZonedDateTime createZonedDateTime(int n, Month month, int n2) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(n, month, n2));
    }

    public static @NonNull ZonedDateTime createZonedDateTimeUTC(int n, Month month, int n2) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(n, month, n2));
    }

    public static @NonNull ZonedDateTime createZonedDateTime(int n, @NonNull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createZonedDateTime(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    public static @NonNull ZonedDateTime createZonedDateTimeUTC(int n, @NonNull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createZonedDateTimeUTC(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    private static @NonNull ZonedDateTime _toZonedDateTime(@NonNull Instant instant) {
        return ZonedDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory._toZonedDateTime(instant);
    }

    public static @Nullable ZonedDateTime createZonedDateTimeUTC(@Nullable Instant instant) {
        return instant == null ? null : ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime();
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable Date date) {
        return date == null ? null : PDTFactory._toOffsetDateTime(date).toZonedDateTime();
    }

    public static @Nullable ZonedDateTime createZonedDateTime(@Nullable Timestamp timestamp) {
        return PDTFactory.createZonedDateTime(PDTFactory.createOffsetDateTime(timestamp));
    }

    public static @NonNull ZonedDateTime createZonedDateTime(long l) {
        return PDTFactory._toZonedDateTime(Instant.ofEpochMilli(l));
    }

    public static @NonNull ZonedDateTime createZonedDateTimeUTC(long l) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneOffset.UTC);
    }

    public static @NonNull ZonedDateTime createZonedDateTime(@Nullable Number number) {
        return number == null ? null : PDTFactory.createZonedDateTime(number.longValue());
    }

    public static @NonNull ZonedDateTime createZonedDateTimeUTC(@Nullable Number number) {
        return number == null ? null : PDTFactory.createZonedDateTimeUTC(number.longValue());
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTime() {
        return OffsetDateTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTimeUTC() {
        return OffsetDateTime.now(ZoneOffset.UTC);
    }

    public static @Nullable OffsetDateTime getWithMillisOnly(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.truncatedTo(ChronoUnit.MILLIS);
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetDateTime());
    }

    @Nonnegative
    public static OffsetDateTime getCurrentOffsetDateTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetDateTimeUTC());
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toOffsetDateTime();
    }

    private static @Nullable OffsetDateTime _toOffsetDateTime(@NonNull LocalDateTime localDateTime) {
        return ZonedDateTime.of(localDateTime, PDTFactory._getZoneId()).toOffsetDateTime();
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : PDTFactory._toOffsetDateTime(localDateTime);
    }

    public static @Nullable OffsetDateTime createOffsetDateTimeUTC(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable LocalDate localDate) {
        return localDate == null ? null : PDTFactory._toOffsetDateTime(localDate.atStartOfDay());
    }

    public static @Nullable OffsetDateTime createOffsetDateTimeUTC(@Nullable LocalDate localDate) {
        return localDate == null ? null : PDTFactory.createOffsetDateTimeUTC(localDate.atStartOfDay());
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : OffsetDateTime.of(offsetDate.toLocalDate().atStartOfDay(), offsetDate.getOffset());
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable XMLOffsetDate xMLOffsetDate) {
        return xMLOffsetDate == null ? null : PDTFactory.createZonedDateTime(xMLOffsetDate).toOffsetDateTime();
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable YearMonth yearMonth) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(yearMonth));
    }

    public static @Nullable OffsetDateTime createOffsetDateTimeUTC(@Nullable YearMonth yearMonth) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(yearMonth));
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable Year year) {
        return PDTFactory.createOffsetDateTime(PDTFactory.createLocalDateTime(year));
    }

    public static @Nullable OffsetDateTime createOffsetDateTimeUTC(@Nullable Year year) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(year));
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : PDTFactory._toOffsetDateTime(PDTFactory._toLocalDateTime(localTime));
    }

    public static @Nullable OffsetDateTime createOffsetDateTimeUTC(@Nullable LocalTime localTime) {
        return localTime == null ? null : PDTFactory.createOffsetDateTimeUTC(PDTFactory._toLocalDateTime(localTime));
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : offsetTime.atDate(LocalDate.ofEpochDay(0L));
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable XMLOffsetTime xMLOffsetTime) {
        return xMLOffsetTime == null ? null : xMLOffsetTime.atDate(LocalDate.ofEpochDay(0L));
    }

    public static @NonNull OffsetDateTime createOffsetDateTime(int n, Month month, int n2) {
        return PDTFactory._toOffsetDateTime(PDTFactory.createLocalDate(n, month, n2).atStartOfDay());
    }

    public static @NonNull OffsetDateTime createOffsetDateTimeUTC(int n, Month month, int n2) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDate(n, month, n2).atStartOfDay());
    }

    public static @NonNull OffsetDateTime createOffsetDateTime(int n, @NonNull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory._toOffsetDateTime(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    public static @NonNull OffsetDateTime createOffsetDateTime(int n, @NonNull Month month, int n2, int n3, int n4, int n5, @NonNull ZoneOffset zoneOffset) {
        return OffsetDateTime.of(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5), zoneOffset);
    }

    public static @NonNull OffsetDateTime createOffsetDateTimeUTC(int n, @NonNull Month month, int n2, int n3, int n4, int n5) {
        return PDTFactory.createOffsetDateTimeUTC(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5));
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable Instant instant) {
        return instant == null ? null : OffsetDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    public static @Nullable OffsetDateTime createOffsetDateTimeUTC(@Nullable Instant instant) {
        return instant == null ? null : OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    private static @NonNull OffsetDateTime _toOffsetDateTime(@NonNull Date date) {
        return date.toInstant().atOffset(PDTFactory.getZoneOffset(date));
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable Date date) {
        return date == null ? null : PDTFactory._toOffsetDateTime(date);
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable Timestamp timestamp) {
        return timestamp == null ? null : PDTFactory._toOffsetDateTime(timestamp);
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toOffsetDateTime();
    }

    public static @NonNull OffsetDateTime createOffsetDateTime(long l) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(l), PDTFactory._getZoneId());
    }

    public static @NonNull OffsetDateTime createOffsetDateTimeUTC(long l) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneOffset.UTC);
    }

    public static @Nullable OffsetDateTime createOffsetDateTime(@Nullable Number number) {
        return number == null ? null : PDTFactory.createOffsetDateTime(number.longValue());
    }

    public static @Nullable OffsetDateTime createOffsetDateTimeUTC(@Nullable Number number) {
        return number == null ? null : PDTFactory.createOffsetDateTimeUTC(number.longValue());
    }

    @Nonnegative
    public static XMLOffsetDateTime getCurrentXMLOffsetDateTime() {
        return XMLOffsetDateTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static XMLOffsetDateTime getCurrentXMLOffsetDateTimeUTC() {
        return XMLOffsetDateTime.now(ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime getWithMillisOnly(@Nullable XMLOffsetDateTime xMLOffsetDateTime) {
        return xMLOffsetDateTime == null ? null : xMLOffsetDateTime.truncatedTo(ChronoUnit.MILLIS);
    }

    @Nonnegative
    public static XMLOffsetDateTime getCurrentXMLOffsetDateTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentXMLOffsetDateTime());
    }

    @Nonnegative
    public static XMLOffsetDateTime getCurrentXMLOffsetDateTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentXMLOffsetDateTimeUTC());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : XMLOffsetDateTime.of(zonedDateTime.toLocalDateTime(), zonedDateTime.getOffset());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : XMLOffsetDateTime.of(offsetDateTime.toLocalDateTime(), offsetDateTime.getOffset());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : XMLOffsetDateTime.of(localDateTime, null);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTimeUTC(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : XMLOffsetDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable LocalDate localDate) {
        return localDate == null ? null : XMLOffsetDateTime.of(localDate.atStartOfDay(), null);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTimeUTC(@Nullable LocalDate localDate) {
        return localDate == null ? null : XMLOffsetDateTime.of(localDate.atStartOfDay(), ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : XMLOffsetDateTime.of(offsetDate.toLocalDate().atStartOfDay(), offsetDate.getOffset());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable XMLOffsetDate xMLOffsetDate) {
        return xMLOffsetDate == null ? null : XMLOffsetDateTime.of(xMLOffsetDate.toLocalDate().atStartOfDay(), xMLOffsetDate.getOffset());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : XMLOffsetDateTime.of(yearMonth.atDay(1).atStartOfDay(), null);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTimeUTC(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : XMLOffsetDateTime.of(yearMonth.atDay(1).atStartOfDay(), ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable Year year) {
        return year == null ? null : XMLOffsetDateTime.of(year.atDay(1).atStartOfDay(), null);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTimeUTC(@Nullable Year year) {
        return year == null ? null : XMLOffsetDateTime.of(year.atDay(1).atStartOfDay(), ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : XMLOffsetDateTime.of(PDTFactory._toLocalDateTime(localTime), null);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTimeUTC(@Nullable LocalTime localTime) {
        return localTime == null ? null : XMLOffsetDateTime.of(PDTFactory._toLocalDateTime(localTime), ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : XMLOffsetDateTime.of(PDTFactory._toLocalDateTime(offsetTime.toLocalTime()), offsetTime.getOffset());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable XMLOffsetTime xMLOffsetTime) {
        return xMLOffsetTime == null ? null : xMLOffsetTime.atXMLDate(LocalDate.ofEpochDay(0L));
    }

    public static @NonNull XMLOffsetDateTime createXMLOffsetDateTime(int n, Month month, int n2) {
        return XMLOffsetDateTime.of(PDTFactory.createLocalDate(n, month, n2).atStartOfDay(), null);
    }

    public static @NonNull XMLOffsetDateTime createXMLOffsetDateTimeUTC(int n, Month month, int n2) {
        return XMLOffsetDateTime.of(PDTFactory.createLocalDate(n, month, n2).atStartOfDay(), ZoneOffset.UTC);
    }

    public static @NonNull XMLOffsetDateTime createXMLOffsetDateTime(int n, @NonNull Month month, int n2, int n3, int n4, int n5) {
        return XMLOffsetDateTime.of(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5), null);
    }

    public static @NonNull XMLOffsetDateTime createXMLOffsetDateTime(int n, @NonNull Month month, int n2, int n3, int n4, int n5, @Nullable ZoneOffset zoneOffset) {
        return XMLOffsetDateTime.of(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5), zoneOffset);
    }

    public static @NonNull XMLOffsetDateTime createXMLOffsetDateTimeUTC(int n, @NonNull Month month, int n2, int n3, int n4, int n5) {
        return XMLOffsetDateTime.of(PDTFactory.createLocalDateTime(n, month, n2, n3, n4, n5), ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable Instant instant) {
        return instant == null ? null : XMLOffsetDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTimeUTC(@Nullable Instant instant) {
        return instant == null ? null : XMLOffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable Date date) {
        return date == null ? null : XMLOffsetDateTime.ofInstant(date.toInstant(), PDTFactory.getZoneOffset(date));
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable Timestamp timestamp) {
        return timestamp == null ? null : XMLOffsetDateTime.ofInstant(timestamp.toInstant(), PDTFactory.getZoneOffset(timestamp));
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : PDTFactory.createXMLOffsetDateTime(gregorianCalendar.toZonedDateTime());
    }

    public static @NonNull XMLOffsetDateTime createXMLOffsetDateTime(long l) {
        return XMLOffsetDateTime.ofInstant(Instant.ofEpochMilli(l), PDTFactory._getZoneId());
    }

    public static @NonNull XMLOffsetDateTime createXMLOffsetDateTimeUTC(long l) {
        return XMLOffsetDateTime.ofInstant(Instant.ofEpochMilli(l), ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTime(@Nullable Number number) {
        return number == null ? null : PDTFactory.createXMLOffsetDateTime(number.longValue());
    }

    public static @Nullable XMLOffsetDateTime createXMLOffsetDateTimeUTC(@Nullable Number number) {
        return number == null ? null : PDTFactory.createXMLOffsetDateTimeUTC(number.longValue());
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTime() {
        return LocalDateTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTimeUTC() {
        return LocalDateTime.now(ZoneOffset.UTC);
    }

    public static @Nullable LocalDateTime getWithMillisOnly(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.truncatedTo(ChronoUnit.MILLIS);
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnegative
    public static LocalDateTime getCurrentLocalDateTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalDateTimeUTC());
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toLocalDateTime();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toLocalDateTime();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable XMLOffsetDateTime xMLOffsetDateTime) {
        return xMLOffsetDateTime == null ? null : xMLOffsetDateTime.toLocalDateTime();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : offsetDate.toLocalDate().atStartOfDay();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable XMLOffsetDate xMLOffsetDate) {
        return xMLOffsetDate == null ? null : xMLOffsetDate.toLocalDate().atStartOfDay();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable LocalDate localDate) {
        return localDate == null ? null : localDate.atStartOfDay();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : yearMonth.atDay(1).atStartOfDay();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable Year year) {
        return year == null ? null : year.atDay(1).atStartOfDay();
    }

    private static @NonNull LocalDateTime _toLocalDateTime(@NonNull LocalTime localTime) {
        return localTime.atDate(LocalDate.ofEpochDay(0L));
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : PDTFactory._toLocalDateTime(localTime);
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : PDTFactory._toLocalDateTime(offsetTime.toLocalTime());
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable XMLOffsetTime xMLOffsetTime) {
        return xMLOffsetTime == null ? null : PDTFactory._toLocalDateTime(xMLOffsetTime.toLocalTime());
    }

    public static @NonNull LocalDateTime createLocalDateTime(int n, @NonNull Month month, int n2) {
        return PDTFactory.createLocalDateTime(n, month, n2, 0, 0, 0);
    }

    public static @NonNull LocalDateTime createLocalDateTime(int n, @NonNull Month month, int n2, int n3, int n4) {
        return PDTFactory.createLocalDateTime(n, month, n2, n3, n4, 0);
    }

    public static @NonNull LocalDateTime createLocalDateTime(int n, @NonNull Month month, int n2, int n3, int n4, int n5) {
        return LocalDateTime.of(n, month, n2, n3, n4, n5);
    }

    private static @NonNull LocalDateTime _toLocalDateTime(@Nullable Instant instant) {
        return LocalDateTime.ofInstant(instant, PDTFactory._getZoneId());
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory._toLocalDateTime(instant);
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable Date date) {
        return date == null ? null : PDTFactory._toLocalDateTime(date.toInstant());
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable Timestamp timestamp) {
        return timestamp == null ? null : timestamp.toLocalDateTime();
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toLocalDateTime();
    }

    public static @NonNull LocalDateTime createLocalDateTime(long l) {
        return PDTFactory._toLocalDateTime(Instant.ofEpochMilli(l));
    }

    public static @Nullable LocalDateTime createLocalDateTime(@Nullable Number number) {
        return number == null ? null : PDTFactory.createLocalDateTime(number.longValue());
    }

    @Nonnegative
    public static LocalDate getCurrentLocalDate() {
        return LocalDate.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static LocalDate getCurrentLocalDateUTC() {
        return LocalDate.now(ZoneOffset.UTC);
    }

    public static @NonNull LocalDate createLocalDate(int n, @NonNull Month month, int n2) {
        return LocalDate.of(n, month, n2);
    }

    public static @Nullable LocalDate createLocalDate(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toLocalDate();
    }

    public static @NonNull LocalDate createLocalDate(long l) {
        return PDTFactory.createLocalDateTime(l).toLocalDate();
    }

    public static @NonNull LocalDate createLocalDate(@Nullable Number number) {
        return number == null ? null : PDTFactory.createLocalDateTime(number.longValue()).toLocalDate();
    }

    public static @Nullable LocalDate createLocalDate(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory._toLocalDateTime(instant).toLocalDate();
    }

    public static @Nullable LocalDate createLocalDate(@Nullable Date date) {
        return date == null ? null : PDTFactory._toLocalDateTime(date.toInstant()).toLocalDate();
    }

    public static @Nullable LocalDate createLocalDate(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : yearMonth.atDay(1);
    }

    public static @Nullable LocalDate createLocalDate(@Nullable Year year) {
        return year == null ? null : year.atDay(1);
    }

    public static @Nullable LocalDate createLocalDate(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    public static @Nullable LocalDate createLocalDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toLocalDate();
    }

    public static @Nullable LocalDate createLocalDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toLocalDate();
    }

    public static @Nullable LocalDate createLocalDate(@Nullable XMLOffsetDateTime xMLOffsetDateTime) {
        return xMLOffsetDateTime == null ? null : xMLOffsetDateTime.toLocalDate();
    }

    public static @Nullable LocalDate createLocalDate(@Nullable XMLOffsetDate xMLOffsetDate) {
        return xMLOffsetDate == null ? null : xMLOffsetDate.toLocalDate();
    }

    @Nonnegative
    public static OffsetDate getCurrentOffsetDate() {
        return OffsetDate.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static OffsetDate getCurrentOffsetDateUTC() {
        return OffsetDate.now(ZoneOffset.UTC);
    }

    private static @NonNull ZoneOffset _getFallbackZoneOffset() {
        return ZoneOffset.UTC;
    }

    private static @NonNull ZoneOffset _getFallbackZoneOffset(@Nullable Instant instant) {
        if (instant == null) {
            return PDTFactory._getFallbackZoneOffset();
        }
        return PDTFactory._getZoneId().getRules().getOffset(instant);
    }

    private static @NonNull ZoneOffset _getFallbackZoneOffset(@Nullable LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return PDTFactory._getFallbackZoneOffset();
        }
        return PDTFactory._getZoneId().getRules().getOffset(localDateTime);
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable LocalDate localDate) {
        return localDate == null ? null : OffsetDate.of(localDate, PDTFactory._getFallbackZoneOffset(localDate.atStartOfDay()));
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable LocalDate localDate, @NonNull ZoneOffset zoneOffset) {
        return localDate == null ? null : OffsetDate.of(localDate, zoneOffset);
    }

    public static @NonNull OffsetDate createOffsetDate(int n, @NonNull Month month, int n2) {
        LocalDate localDate = PDTFactory.createLocalDate(n, month, n2);
        return OffsetDate.of(localDate, PDTFactory._getFallbackZoneOffset(localDate.atStartOfDay()));
    }

    public static @NonNull OffsetDate createOffsetDate(int n, @NonNull Month month, int n2, @NonNull ZoneOffset zoneOffset) {
        return OffsetDate.of(n, month, n2, zoneOffset);
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : OffsetDate.of(localDateTime.toLocalDate(), PDTFactory._getFallbackZoneOffset(localDateTime));
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable LocalDateTime localDateTime, @NonNull ZoneOffset zoneOffset) {
        return localDateTime == null ? null : OffsetDate.of(localDateTime.toLocalDate(), zoneOffset);
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : PDTFactory.createOffsetDate(gregorianCalendar.toZonedDateTime());
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable Instant instant) {
        return instant == null ? null : OffsetDate.ofInstant(instant, PDTFactory._getZoneId());
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable Instant instant, @NonNull ZoneOffset zoneOffset) {
        return instant == null ? null : OffsetDate.ofInstant(instant, zoneOffset);
    }

    public static @NonNull OffsetDate createOffsetDate(long l) {
        return PDTFactory.createOffsetDate(Instant.ofEpochMilli(l));
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable Number number) {
        return number == null ? null : PDTFactory.createOffsetDate(number.longValue());
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable Date date) {
        return date == null ? null : PDTFactory.createOffsetDate(PDTFactory._toOffsetDateTime(date));
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : PDTFactory.createOffsetDate(yearMonth.atDay(1));
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable Year year) {
        return year == null ? null : PDTFactory.createOffsetDate(year.atDay(1));
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : OffsetDate.of(offsetDateTime.toLocalDate(), offsetDateTime.getOffset());
    }

    public static @Nullable OffsetDate createOffsetDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : OffsetDate.of(zonedDateTime.toLocalDate(), zonedDateTime.getOffset());
    }

    @Nonnegative
    public static XMLOffsetDate getCurrentXMLOffsetDate() {
        return XMLOffsetDate.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static XMLOffsetDate getCurrentXMLOffsetDateUTC() {
        return XMLOffsetDate.now(ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : XMLOffsetDate.of(zonedDateTime.toLocalDate(), zonedDateTime.getOffset());
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : XMLOffsetDate.of(offsetDateTime.toLocalDate(), offsetDateTime.getOffset());
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable XMLOffsetDateTime xMLOffsetDateTime) {
        return xMLOffsetDateTime == null ? null : XMLOffsetDate.of(xMLOffsetDateTime.toLocalDate(), xMLOffsetDateTime.getOffset());
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable LocalDate localDate) {
        return PDTFactory.createXMLOffsetDate(localDate, null);
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable LocalDate localDate, @NonNull ZoneOffset zoneOffset) {
        return localDate == null ? null : XMLOffsetDate.of(localDate, zoneOffset);
    }

    public static @NonNull XMLOffsetDate createXMLOffsetDate(int n, @NonNull Month month, int n2) {
        return PDTFactory.createXMLOffsetDate(n, month, n2, null);
    }

    public static @NonNull XMLOffsetDate createXMLOffsetDate(int n, @NonNull Month month, int n2, @Nullable ZoneOffset zoneOffset) {
        return XMLOffsetDate.of(n, month, n2, zoneOffset);
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable LocalDateTime localDateTime) {
        return PDTFactory.createXMLOffsetDate(localDateTime, null);
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable LocalDateTime localDateTime, @NonNull ZoneOffset zoneOffset) {
        return localDateTime == null ? null : XMLOffsetDate.of(localDateTime.toLocalDate(), zoneOffset);
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable Instant instant) {
        return instant == null ? null : XMLOffsetDate.ofInstant(instant, PDTFactory._getZoneId());
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable Instant instant, @NonNull ZoneId zoneId) {
        return instant == null ? null : XMLOffsetDate.ofInstant(instant, zoneId);
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : PDTFactory.createXMLOffsetDate(gregorianCalendar.toZonedDateTime());
    }

    public static @NonNull XMLOffsetDate createXMLOffsetDate(long l) {
        return PDTFactory.createXMLOffsetDate(Instant.ofEpochMilli(l));
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable Date date) {
        return date == null ? null : PDTFactory.createXMLOffsetDate(PDTFactory._toOffsetDateTime(date));
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable YearMonth yearMonth) {
        return yearMonth == null ? null : PDTFactory.createXMLOffsetDate(yearMonth.atDay(1));
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable Year year) {
        return year == null ? null : PDTFactory.createXMLOffsetDate(year.atDay(1));
    }

    public static @Nullable XMLOffsetDate createXMLOffsetDate(@Nullable Number number) {
        return number == null ? null : PDTFactory.createXMLOffsetDate(number.longValue());
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTime() {
        return LocalTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTimeUTC() {
        return LocalTime.now(ZoneOffset.UTC);
    }

    public static @Nullable LocalTime getWithMillisOnly(@Nullable LocalTime localTime) {
        return localTime == null ? null : localTime.truncatedTo(ChronoUnit.MILLIS);
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalTime());
    }

    @Nonnegative
    public static LocalTime getCurrentLocalTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentLocalTimeUTC());
    }

    public static @Nullable LocalTime createLocalTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toLocalTime();
    }

    public static @NonNull LocalTime createLocalTime(long l) {
        return PDTFactory.createLocalDateTime(l).toLocalTime();
    }

    public static @Nullable LocalTime createLocalTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createLocalDateTime(instant).toLocalTime();
    }

    public static @Nullable LocalTime createLocalTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createLocalTime(date.toInstant());
    }

    public static @Nullable LocalTime createLocalTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    public static @Nullable LocalTime createLocalTime(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : offsetTime.toLocalTime();
    }

    public static @Nullable LocalTime createLocalTime(@Nullable XMLOffsetTime xMLOffsetTime) {
        return xMLOffsetTime == null ? null : xMLOffsetTime.toLocalTime();
    }

    public static @NonNull LocalTime createLocalTime(int n, int n2, int n3) {
        return LocalTime.of(n, n2, n3);
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTime() {
        return OffsetTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTimeUTC() {
        return OffsetTime.now(ZoneOffset.UTC);
    }

    public static @Nullable OffsetTime getWithMillisOnly(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : offsetTime.truncatedTo(ChronoUnit.MILLIS);
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetTime());
    }

    @Nonnegative
    public static OffsetTime getCurrentOffsetTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentOffsetTimeUTC());
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : gregorianCalendar.toZonedDateTime().toOffsetDateTime().toOffsetTime();
    }

    public static @NonNull OffsetTime createOffsetTime(long l) {
        return PDTFactory.createOffsetDateTime(l).toOffsetTime();
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createOffsetDateTime(instant).toOffsetTime();
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createOffsetTime(date.toInstant());
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : offsetDateTime.toOffsetTime();
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : zonedDateTime.toOffsetDateTime().toOffsetTime();
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : localDateTime.toLocalTime().atOffset(PDTFactory._getFallbackZoneOffset(localDateTime));
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable LocalDateTime localDateTime, @NonNull ZoneOffset zoneOffset) {
        return localDateTime == null ? null : localDateTime.toLocalTime().atOffset(zoneOffset);
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : localTime.atOffset(PDTFactory._getFallbackZoneOffset());
    }

    public static @Nullable OffsetTime createOffsetTime(@Nullable LocalTime localTime, @NonNull ZoneOffset zoneOffset) {
        return localTime == null ? null : localTime.atOffset(zoneOffset);
    }

    public static @NonNull OffsetTime createOffsetTime(int n, int n2, int n3, @NonNull ZoneOffset zoneOffset) {
        return OffsetTime.of(n, n2, n3, 0, zoneOffset);
    }

    @Nonnegative
    public static XMLOffsetTime getCurrentXMLOffsetTime() {
        return XMLOffsetTime.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static XMLOffsetTime getCurrentXMLOffsetTimeUTC() {
        return XMLOffsetTime.now(ZoneOffset.UTC);
    }

    public static @Nullable XMLOffsetTime getWithMillisOnly(@Nullable XMLOffsetTime xMLOffsetTime) {
        return xMLOffsetTime == null ? null : xMLOffsetTime.truncatedTo(ChronoUnit.MILLIS);
    }

    @Nonnegative
    public static XMLOffsetTime getCurrentXMLOffsetTimeMillisOnly() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentXMLOffsetTime());
    }

    @Nonnegative
    public static XMLOffsetTime getCurrentXMLOffsetTimeMillisOnlyUTC() {
        return PDTFactory.getWithMillisOnly(PDTFactory.getCurrentXMLOffsetTimeUTC());
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable GregorianCalendar gregorianCalendar) {
        return gregorianCalendar == null ? null : XMLOffsetTime.of(gregorianCalendar.toZonedDateTime().toOffsetDateTime().toOffsetTime());
    }

    public static @NonNull XMLOffsetTime createXMLOffsetTime(long l) {
        return PDTFactory.createXMLOffsetDateTime(l).toXMLOffsetTime();
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable Instant instant) {
        return instant == null ? null : PDTFactory.createXMLOffsetDateTime(instant).toXMLOffsetTime();
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable Date date) {
        return date == null ? null : PDTFactory.createXMLOffsetTime(date.toInstant());
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : XMLOffsetTime.of(offsetDateTime.toOffsetTime());
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : XMLOffsetTime.of(zonedDateTime.toOffsetDateTime().toOffsetTime());
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : XMLOffsetTime.of(localDateTime.toLocalTime(), null);
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable LocalDateTime localDateTime, @Nullable ZoneOffset zoneOffset) {
        return localDateTime == null ? null : XMLOffsetTime.of(localDateTime.toLocalTime(), zoneOffset);
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable LocalTime localTime) {
        return localTime == null ? null : XMLOffsetTime.of(localTime, null);
    }

    public static @Nullable XMLOffsetTime createXMLOffsetTime(@Nullable LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        return localTime == null ? null : XMLOffsetTime.of(localTime, zoneOffset);
    }

    public static @NonNull XMLOffsetTime createXMLOffsetTime(int n, int n2, int n3) {
        return PDTFactory.createXMLOffsetTime(n, n2, n3, null);
    }

    public static @NonNull XMLOffsetTime createXMLOffsetTime(int n, int n2, int n3, @Nullable ZoneOffset zoneOffset) {
        return XMLOffsetTime.of(n, n2, n3, 0, zoneOffset);
    }

    public static @Nullable Date createDate(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : Date.from(zonedDateTime.toInstant());
    }

    public static @Nullable Date createDate(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : Date.from(offsetDateTime.toInstant());
    }

    public static @Nullable Date createDate(@Nullable LocalDateTime localDateTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localDateTime));
    }

    public static @Nullable Date createDate(@Nullable LocalDate localDate) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localDate));
    }

    public static @Nullable Date createDate(@Nullable OffsetDate offsetDate) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(offsetDate));
    }

    public static @Nullable Date createDate(@Nullable XMLOffsetDate xMLOffsetDate) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(xMLOffsetDate));
    }

    public static @Nullable Date createDate(@Nullable LocalTime localTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(localTime));
    }

    public static @Nullable Date createDate(@Nullable OffsetTime offsetTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(offsetTime));
    }

    public static @Nullable Date createDate(@Nullable XMLOffsetTime xMLOffsetTime) {
        return PDTFactory.createDate(PDTFactory.createZonedDateTime(xMLOffsetTime));
    }

    public static @NonNull Date createDateForDate(int n, @NonNull Month month, int n2) {
        return PDTFactory.createDate(PDTFactory.createLocalDate(n, month, n2));
    }

    public static @NonNull Date createDateForTime(int n, int n2, int n3) {
        return PDTFactory.createDate(PDTFactory.createLocalTime(n, n2, n3));
    }

    public static @NonNull Calendar createCalendar() {
        return Calendar.getInstance(PDTConfig.getDefaultTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    public static @NonNull Calendar createCalendarUTC() {
        return Calendar.getInstance(PDTConfig.getUTCTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    public static @NonNull GregorianCalendar createGregorianCalendar() {
        return new GregorianCalendar(PDTConfig.getDefaultTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    public static @NonNull GregorianCalendar createGregorianCalendarUTC() {
        return new GregorianCalendar(PDTConfig.getUTCTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnegative
    public static int getCurrentYear() {
        return PDTFactory.getCurrentLocalDate().getYear();
    }

    @Nonnegative
    public static int getCurrentYearUTC() {
        return PDTFactory.getCurrentLocalDateUTC().getYear();
    }

    public static @NonNull Year getCurrentYearObj() {
        return Year.now(PDTFactory._getZoneId());
    }

    public static @NonNull Year getCurrentYearObjUTC() {
        return Year.now(ZoneOffset.UTC);
    }

    public static @NonNull MonthDay getCurrentMonthDay() {
        return MonthDay.now(PDTFactory._getZoneId());
    }

    public static @NonNull MonthDay getCurrentMonthDayUTC() {
        return MonthDay.now(ZoneOffset.UTC);
    }

    @Nonnegative
    public static YearMonth getCurrentYearMonth() {
        return YearMonth.now(PDTFactory._getZoneId());
    }

    @Nonnegative
    public static YearMonth getCurrentYearMonthUTC() {
        return YearMonth.now(ZoneOffset.UTC);
    }

    @Nonnegative
    public static Instant getCurrentInstant() {
        return Instant.now(Clock.system(PDTFactory._getZoneId()));
    }

    @Nonnegative
    public static Instant getCurrentInstantUTC() {
        return Instant.now(Clock.system(ZoneOffset.UTC));
    }

    public static long getCurrentMillis() {
        return PDTFactory.getCurrentInstant().toEpochMilli();
    }

    public static long getCurrentMillisUTC() {
        return PDTFactory.getCurrentInstantUTC().toEpochMilli();
    }

    public static long getMillis(@NonNull LocalDate localDate) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(localDate));
    }

    public static long getMillis(@NonNull OffsetDate offsetDate) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(offsetDate));
    }

    public static long getMillis(@NonNull XMLOffsetDate xMLOffsetDate) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(xMLOffsetDate));
    }

    public static long getMillis(@NonNull LocalTime localTime) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(localTime));
    }

    public static long getMillis(@NonNull OffsetTime offsetTime) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(offsetTime));
    }

    public static long getMillis(@NonNull XMLOffsetTime xMLOffsetTime) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(xMLOffsetTime));
    }

    public static long getMillis(@NonNull LocalDateTime localDateTime) {
        return PDTFactory.getMillis(PDTFactory.createZonedDateTime(localDateTime));
    }

    public static long getMillis(@NonNull OffsetDateTime offsetDateTime) {
        return offsetDateTime.toInstant().toEpochMilli();
    }

    public static long getMillis(@NonNull XMLOffsetDateTime xMLOffsetDateTime) {
        return xMLOffsetDateTime.toInstant().toEpochMilli();
    }

    public static long getMillis(@NonNull ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }
}

