/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.xml;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.zone.PDTConfig;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;

@Immutable
public class XMLOffsetDate
implements Temporal,
TemporalAdjuster,
Comparable<XMLOffsetDate>,
Serializable {
    public static final XMLOffsetDate MIN = XMLOffsetDate.of(LocalDate.MIN, ZoneOffset.MAX);
    public static final XMLOffsetDate MAX = XMLOffsetDate.of(LocalDate.MAX, ZoneOffset.MIN);
    private static final long SECONDS_PER_DAY = 86400L;
    private final LocalDate m_aDate;
    private final ZoneOffset m_aOffset;

    @Nonnull
    public static XMLOffsetDate now() {
        return XMLOffsetDate.now(Clock.systemDefaultZone());
    }

    @Nonnull
    public static XMLOffsetDate now(@Nonnull ZoneId zoneId) {
        return XMLOffsetDate.now(Clock.system(zoneId));
    }

    @Nonnull
    public static XMLOffsetDate now(@Nonnull Clock clock) {
        ValueEnforcer.notNull((Object)clock, (String)"clock");
        Instant instant = clock.instant();
        return XMLOffsetDate.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    @Nonnull
    public static XMLOffsetDate of(@Nonnull LocalDate localDate) {
        return new XMLOffsetDate(localDate, null);
    }

    @Nonnull
    public static XMLOffsetDate of(@Nonnull LocalDate localDate, @Nullable ZoneOffset zoneOffset) {
        return new XMLOffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDate of(@Nonnull OffsetDate offsetDate) {
        return new XMLOffsetDate(offsetDate.toLocalDate(), offsetDate.getOffset());
    }

    @Nonnull
    public static XMLOffsetDate of(int n, int n2, int n3, @Nullable ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.of(n, n2, n3);
        return new XMLOffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDate of(int n, Month month, int n2, @Nullable ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.of(n, month, n2);
        return new XMLOffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDate ofInstant(@Nonnull Instant instant, @Nonnull ZoneId zoneId) {
        ValueEnforcer.notNull((Object)instant, (String)"instant");
        ValueEnforcer.notNull((Object)zoneId, (String)"zone");
        ZoneOffset zoneOffset = zoneId.getRules().getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        long l2 = Math.floorDiv(l, 86400L);
        LocalDate localDate = LocalDate.ofEpochDay(l2);
        return new XMLOffsetDate(localDate, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetDate from(@Nonnull TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof XMLOffsetDate) {
            XMLOffsetDate xMLOffsetDate = (XMLOffsetDate)temporalAccessor;
            return xMLOffsetDate;
        }
        try {
            ZoneOffset zoneOffset;
            LocalDate localDate = LocalDate.from(temporalAccessor);
            try {
                zoneOffset = ZoneOffset.from(temporalAccessor);
            }
            catch (DateTimeException dateTimeException) {
                zoneOffset = null;
            }
            return new XMLOffsetDate(localDate, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain XMLOffsetDate from TemporalAccessor: " + String.valueOf(temporalAccessor.getClass()), dateTimeException);
        }
    }

    @Nonnull
    public static XMLOffsetDate parse(@Nonnull CharSequence charSequence) {
        return XMLOffsetDate.parse(charSequence, DateTimeFormatter.ISO_DATE);
    }

    @Nonnull
    public static XMLOffsetDate parse(@Nonnull CharSequence charSequence, @Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"formatter");
        return dateTimeFormatter.parse(charSequence, XMLOffsetDate::from);
    }

    protected XMLOffsetDate(@Nonnull LocalDate localDate, @Nullable ZoneOffset zoneOffset) {
        ValueEnforcer.notNull((Object)localDate, (String)"date");
        this.m_aDate = localDate;
        this.m_aOffset = zoneOffset;
    }

    @Nonnull
    private XMLOffsetDate with(@Nonnull LocalDate localDate, @Nullable ZoneOffset zoneOffset) {
        if (this.m_aDate == localDate && EqualsHelper.equals((Object)this.m_aOffset, (Object)zoneOffset)) {
            return this;
        }
        return new XMLOffsetDate(localDate, zoneOffset);
    }

    @Override
    public boolean isSupported(@Nullable TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isDateBased() || temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(@Nullable TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isDateBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    public ValueRange range(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.m_aDate.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(@Nonnull TemporalField temporalField) {
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                if (this.m_aOffset != null) {
                    return this.m_aOffset.getTotalSeconds();
                }
                throw new DateTimeException("No offset present");
            }
            return this.m_aDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Nullable
    public ZoneOffset getOffset() {
        return this.m_aOffset;
    }

    public boolean hasOffset() {
        return this.m_aOffset != null;
    }

    @Nonnull
    public XMLOffsetDate withOffsetSameLocal(@Nullable ZoneOffset zoneOffset) {
        return this.with(this.m_aDate, zoneOffset);
    }

    @Nonnull
    public LocalDate toLocalDate() {
        return this.m_aDate;
    }

    public int getYear() {
        return this.m_aDate.getYear();
    }

    public int getMonthValue() {
        return this.m_aDate.getMonthValue();
    }

    @Nonnull
    public Month getMonth() {
        return this.m_aDate.getMonth();
    }

    public int getDayOfMonth() {
        return this.m_aDate.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.m_aDate.getDayOfYear();
    }

    @Nonnull
    public DayOfWeek getDayOfWeek() {
        return this.m_aDate.getDayOfWeek();
    }

    @Override
    @Nonnull
    public XMLOffsetDate with(@Nonnull TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAdjuster;
            return this.with(localDate, this.m_aOffset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            ZoneOffset zoneOffset = (ZoneOffset)temporalAdjuster;
            return this.with(this.m_aDate, zoneOffset);
        }
        if (temporalAdjuster instanceof XMLOffsetDate) {
            XMLOffsetDate xMLOffsetDate = (XMLOffsetDate)temporalAdjuster;
            return xMLOffsetDate;
        }
        return (XMLOffsetDate)temporalAdjuster.adjustInto(this);
    }

    @Override
    @Nonnull
    public XMLOffsetDate with(@Nonnull TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this.with(this.m_aDate, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
            }
            return this.with(this.m_aDate.with(temporalField, l), this.m_aOffset);
        }
        return temporalField.adjustInto(this, l);
    }

    @Nonnull
    public XMLOffsetDate withYear(int n) {
        return this.with(this.m_aDate.withYear(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate withMonth(int n) {
        return this.with(this.m_aDate.withMonth(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate withDayOfMonth(int n) {
        return this.with(this.m_aDate.withDayOfMonth(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate withDayOfYear(int n) {
        return this.with(this.m_aDate.withDayOfYear(n), this.m_aOffset);
    }

    @Override
    @Nonnull
    public XMLOffsetDate plus(@Nonnull TemporalAmount temporalAmount) {
        return (XMLOffsetDate)temporalAmount.addTo(this);
    }

    @Override
    @Nonnull
    public XMLOffsetDate plus(long l, @Nonnull TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.m_aDate.plus(l, temporalUnit), this.m_aOffset);
        }
        return temporalUnit.addTo(this, l);
    }

    @Nonnull
    public XMLOffsetDate plusYears(long l) {
        return this.with(this.m_aDate.plusYears(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate plusMonths(long l) {
        return this.with(this.m_aDate.plusMonths(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate plusWeeks(long l) {
        return this.with(this.m_aDate.plusWeeks(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate plusDays(long l) {
        return this.with(this.m_aDate.plusDays(l), this.m_aOffset);
    }

    @Override
    @Nonnull
    public XMLOffsetDate minus(@Nonnull TemporalAmount temporalAmount) {
        return (XMLOffsetDate)temporalAmount.subtractFrom(this);
    }

    @Override
    @Nonnull
    public XMLOffsetDate minus(long l, @Nonnull TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    @Nonnull
    public XMLOffsetDate minusYears(long l) {
        return this.with(this.m_aDate.minusYears(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate minusMonths(long l) {
        return this.with(this.m_aDate.minusMonths(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate minusWeeks(long l) {
        return this.with(this.m_aDate.minusWeeks(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetDate minusDays(long l) {
        return this.with(this.m_aDate.minusDays(l), this.m_aOffset);
    }

    @Override
    @Nonnull
    public <R> R query(@Nonnull TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.chronology()) {
            return (R)IsoChronology.INSTANCE;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.DAYS;
        }
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.getOffsetOrDefault();
        }
        return Temporal.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(@Nonnull Temporal temporal) {
        return temporal.with(ChronoField.EPOCH_DAY, this.toLocalDate().toEpochDay()).with(ChronoField.OFFSET_SECONDS, this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() : 0L);
    }

    @Override
    public long until(@Nonnull Temporal temporal, @Nonnull TemporalUnit temporalUnit) {
        XMLOffsetDate xMLOffsetDate = XMLOffsetDate.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = (long)(xMLOffsetDate.m_aOffset != null ? xMLOffsetDate.m_aOffset.getTotalSeconds() : 0) - (long)(this.m_aOffset != null ? this.m_aOffset.getTotalSeconds() : 0);
            LocalDate localDate = xMLOffsetDate.m_aDate.plusDays(Math.floorDiv(-l, 86400L));
            return this.m_aDate.until(localDate, temporalUnit);
        }
        return temporalUnit.between(this, xMLOffsetDate);
    }

    @Nonnull
    public String format(@Nonnull DateTimeFormatter dateTimeFormatter) {
        ValueEnforcer.notNull((Object)dateTimeFormatter, (String)"formatter");
        return dateTimeFormatter.format(this);
    }

    @Nonnull
    protected ZoneOffset getOffsetOrDefault() {
        ZoneOffset zoneOffset = this.m_aOffset;
        if (zoneOffset == null) {
            zoneOffset = PDTConfig.getDefaultZoneId().getRules().getOffset(this.m_aDate.atStartOfDay());
        }
        return zoneOffset;
    }

    @Nonnull
    public OffsetDateTime atTime(@Nonnull LocalTime localTime) {
        return OffsetDateTime.of(this.m_aDate, localTime, this.getOffsetOrDefault());
    }

    @Nonnull
    public XMLOffsetDateTime atXMLTime(@Nonnull LocalTime localTime) {
        return XMLOffsetDateTime.of(this.m_aDate, localTime, this.m_aOffset);
    }

    protected long toEpochSecond() {
        long l = this.m_aDate.toEpochDay();
        long l2 = l * 86400L;
        return l2 - (long)(this.m_aOffset != null ? this.m_aOffset.getTotalSeconds() : 0);
    }

    public long toEpochSecond(@Nonnull LocalTime localTime) {
        ValueEnforcer.notNull((Object)localTime, (String)"time");
        return this.toEpochSecond() + (long)localTime.toSecondOfDay();
    }

    @Override
    public int compareTo(@Nonnull XMLOffsetDate xMLOffsetDate) {
        if (EqualsHelper.equals((Object)this.m_aOffset, (Object)xMLOffsetDate.m_aOffset)) {
            return this.m_aDate.compareTo(xMLOffsetDate.m_aDate);
        }
        int n = Long.compare(this.toEpochSecond(), xMLOffsetDate.toEpochSecond());
        if (n == 0) {
            n = this.m_aDate.compareTo(xMLOffsetDate.m_aDate);
        }
        return n;
    }

    public boolean isAfter(@Nonnull XMLOffsetDate xMLOffsetDate) {
        return this.toEpochSecond() > xMLOffsetDate.toEpochSecond();
    }

    public boolean isBefore(@Nonnull XMLOffsetDate xMLOffsetDate) {
        return this.toEpochSecond() < xMLOffsetDate.toEpochSecond();
    }

    public boolean isEqual(@Nonnull XMLOffsetDate xMLOffsetDate) {
        return this.toEpochSecond() == xMLOffsetDate.toEpochSecond();
    }

    @Nullable
    public OffsetDate toOffsetDate() {
        return OffsetDate.of(this.m_aDate, this.getOffsetOrDefault());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XMLOffsetDate xMLOffsetDate = (XMLOffsetDate)object;
        return this.m_aDate.equals(xMLOffsetDate.m_aDate) && EqualsHelper.equals((Object)this.m_aOffset, (Object)xMLOffsetDate.m_aOffset);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aDate).append((Object)this.m_aOffset).getHashCode();
    }

    @Nonnull
    @Deprecated(forRemoval=false)
    @Nonempty
    public String getAsString() {
        return this.toString();
    }

    public String toString() {
        return this.m_aDate.toString() + (this.m_aOffset != null ? this.m_aOffset.toString() : "");
    }
}

