/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dao.wal;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTToString;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.EFileIOErrorCode;
import com.helger.commons.io.file.EFileIOOperation;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperationManager;
import com.helger.commons.io.relative.IFileRelativeIO;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.dao.AbstractDAO;
import com.helger.dao.DAOException;
import com.helger.dao.EDAOActionType;
import com.helger.dao.IDAO;
import com.helger.dao.IDAOReadExceptionCallback;
import com.helger.dao.IDAOWriteExceptionCallback;
import com.helger.dao.wal.WALListener;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroComment;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractWALDAO<DATATYPE>
extends AbstractDAO {
    public static final Duration DEFAULT_WAITING_TIME = Duration.ofSeconds(10L);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWALDAO.class);
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterInitSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$init-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterInitTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$init"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterReadSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$read-success"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterReadTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$read"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteTotal = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-total"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteSuccess = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-success"));
    private final IMutableStatisticsHandlerCounter m_aStatsCounterWriteExceptions = StatisticsManager.getCounterHandler((String)(this.getClass().getName() + "$write-exceptions"));
    private final IMutableStatisticsHandlerTimer m_aStatsCounterWriteTimer = StatisticsManager.getTimerHandler((String)(this.getClass().getName() + "$write"));
    public static final IXMLWriterSettings WRITE_XWS = new XMLWriterSettings().setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.WRITE_TO_FILE_NO_LOG);
    public static final IXMLWriterSettings WAL_XWS = new XMLWriterSettings().setIncorrectCharacterHandling(EXMLIncorrectCharacterHandling.WRITE_TO_FILE_NO_LOG).setIndent(EXMLSerializeIndent.NONE);
    private final Class<DATATYPE> m_aDataTypeClass;
    private final IFileRelativeIO m_aIO;
    private final Supplier<String> m_aFilenameProvider;
    private String m_sPreviousFilename;
    private int m_nInitCount = 0;
    private LocalDateTime m_aLastInitDT;
    private int m_nReadCount = 0;
    private LocalDateTime m_aLastReadDT;
    private int m_nWriteCount = 0;
    private LocalDateTime m_aLastWriteDT;
    private boolean m_bCanWriteWAL = true;
    private Duration m_aWaitingTime = DEFAULT_WAITING_TIME;
    private final WALListener m_aWALListener;

    @Nonnull
    private static String _getFilenameNew(@Nonnull String string) {
        return string + ".new";
    }

    @Nonnull
    private static String _getFilenamePrev(@Nonnull String string) {
        return string + ".prev";
    }

    protected AbstractWALDAO(@Nonnull Class<DATATYPE> clazz, @Nonnull IFileRelativeIO iFileRelativeIO, @Nonnull Supplier<String> supplier) {
        this.m_aDataTypeClass = (Class)ValueEnforcer.notNull(clazz, (String)"DataTypeClass");
        this.m_aIO = (IFileRelativeIO)ValueEnforcer.notNull((Object)iFileRelativeIO, (String)"DAOIO");
        this.m_aFilenameProvider = (Supplier)ValueEnforcer.notNull(supplier, (String)"FilenameProvider");
        this.m_aWALListener = WALListener.getInstance();
        String string = this.m_aFilenameProvider.get();
        if (string != null) {
            File file;
            try {
                file = this.getSafeFile(AbstractWALDAO._getFilenameNew(string), IDAO.EMode.WRITE);
                if (file.exists()) {
                    throw new IllegalStateException("The temporary WAL file '" + file.getAbsolutePath() + "' already exists! If the '" + ".new" + "' file is complete, rename it to match '" + string + "'. Please resolve this conflict manually.");
                }
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
            try {
                file = this.getSafeFile(AbstractWALDAO._getFilenamePrev(string), IDAO.EMode.WRITE);
                if (file.exists()) {
                    throw new IllegalStateException("The temporary WAL file '" + file.getAbsolutePath() + "' already exists! If the target filename '" + string + "' exists and is complete, you may consider deleting this '" + ".prev" + "' file. Please resolve this conflict manually.");
                }
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
        }
    }

    final void internalWriteLocked(@Nonnull Runnable runnable) {
        this.m_aRWLock.writeLocked(runnable);
    }

    @Nonnull
    protected final IFileRelativeIO getIO() {
        return this.m_aIO;
    }

    @Nonnull
    public final Supplier<String> getFilenameProvider() {
        return this.m_aFilenameProvider;
    }

    @Nonnull
    @OverrideOnDemand
    protected EChange onInit() {
        return EChange.UNCHANGED;
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    protected abstract EChange onRead(@Nonnull IMicroDocument var1);

    @Nonnull
    protected final File getSafeFile(@Nonnull String string, @Nonnull IDAO.EMode eMode) throws DAOException {
        ValueEnforcer.notNull((Object)string, (String)"Filename");
        ValueEnforcer.notNull((Object)((Object)eMode), (String)"Mode");
        File file = this.m_aIO.getFile(string);
        AbstractWALDAO.checkFileAccess(file, eMode);
        return file;
    }

    protected static void triggerExceptionHandlersRead(@Nonnull Throwable throwable, boolean bl, @Nullable File file) {
        if (AbstractWALDAO.exceptionHandlersRead().isNotEmpty()) {
            FileSystemResource fileSystemResource = file == null ? null : new FileSystemResource(file);
            AbstractWALDAO.exceptionHandlersRead().forEach(arg_0 -> AbstractWALDAO.lambda$triggerExceptionHandlersRead$0(throwable, bl, (IReadableResource)fileSystemResource, arg_0));
        }
    }

    @Nonnull
    protected final Class<DATATYPE> getDataTypeClass() {
        return this.m_aDataTypeClass;
    }

    @Nullable
    @OverrideOnDemand
    @IsLocked(value=ELockType.WRITE)
    protected DATATYPE convertWALStringToNative(@Nonnull String string) {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((String)string);
        if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
            return null;
        }
        return (DATATYPE)MicroTypeConverter.convertToNative((IMicroElement)iMicroDocument.getDocumentElement(), this.m_aDataTypeClass);
    }

    @OverrideOnDemand
    @IsLocked(value=ELockType.WRITE)
    protected void onBetweenReadAndWAL(@Nonnull IMicroDocument iMicroDocument) {
    }

    @OverrideOnDemand
    protected void onRecoveryErrorConvertToNative(@Nonnull EDAOActionType eDAOActionType, @Nonnegative int n, @Nonnull String string) {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Action [" + (Object)((Object)eDAOActionType) + "][" + n + "]: failed to convert the following element to native:\n" + string);
        }
    }

    @IsLocked(value=ELockType.WRITE)
    protected abstract void onRecoveryCreate(@Nonnull DATATYPE var1);

    @IsLocked(value=ELockType.WRITE)
    protected abstract void onRecoveryUpdate(@Nonnull DATATYPE var1);

    @IsLocked(value=ELockType.WRITE)
    protected abstract void onRecoveryDelete(@Nonnull DATATYPE var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initialRead() throws DAOException {
        block69: {
            File file = null;
            String string = this.m_aFilenameProvider.get();
            if (string == null) {
                if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("This DAO of class " + this.getClass().getName() + " will not be able to read from a file");
                }
            } else {
                file = this.getSafeFile(string, IDAO.EMode.READ);
            }
            boolean bl = file == null || !file.exists();
            File file2 = file;
            this.m_aRWLock.writeLock().lock();
            try {
                StopWatch stopWatch;
                Object object;
                this.m_bCanWriteWAL = false;
                IMicroDocument iMicroDocument = null;
                try {
                    object = ESuccess.SUCCESS;
                    if (bl) {
                        if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                            LOGGER.info("Trying to initialize WAL DAO" + (file2 == null ? "" : " XML file '" + file2.getAbsolutePath() + "'"));
                        }
                        this.beginWithoutAutoSave();
                        try {
                            this.m_aStatsCounterInitTotal.increment();
                            stopWatch = StopWatch.createdStarted();
                            if (this.onInit().isChanged() && file2 != null) {
                                object = this._writeToFile();
                            }
                            this.m_aStatsCounterInitTimer.addTime(stopWatch.stopAndGetMillis());
                            this.m_aStatsCounterInitSuccess.increment();
                            ++this.m_nInitCount;
                            this.m_aLastInitDT = PDTFactory.getCurrentLocalDateTime();
                        }
                        finally {
                            this.endWithoutAutoSave();
                            this.internalSetPendingChanges(false);
                        }
                    }
                    if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Trying to read WAL DAO XML file '" + file2.getAbsolutePath() + "'");
                    }
                    this.m_aStatsCounterReadTotal.increment();
                    iMicroDocument = MicroReader.readMicroXML((File)file2);
                    if (iMicroDocument == null) {
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error("Failed to read DAO XML document from file '" + file2.getAbsolutePath() + "'");
                        }
                    } else {
                        this.beginWithoutAutoSave();
                        try {
                            stopWatch = StopWatch.createdStarted();
                            if (this.onRead(iMicroDocument).isChanged()) {
                                object = this._writeToFile();
                            }
                            this.m_aStatsCounterReadTimer.addTime(stopWatch.stopAndGetMillis());
                            this.m_aStatsCounterReadSuccess.increment();
                            ++this.m_nReadCount;
                            this.m_aLastReadDT = PDTFactory.getCurrentLocalDateTime();
                        }
                        finally {
                            this.endWithoutAutoSave();
                            this.internalSetPendingChanges(false);
                        }
                    }
                    if (object.isSuccess()) {
                        this.internalSetPendingChanges(false);
                    } else if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("File '" + file2.getAbsolutePath() + "' has pending changes after initialRead!");
                    }
                }
                catch (Exception exception) {
                    AbstractWALDAO.triggerExceptionHandlersRead(exception, bl, file2);
                    throw new DAOException("Error " + (bl ? "initializing" : "reading") + (file2 == null ? "in-memory" : " the file '" + file2.getAbsolutePath() + "'"), exception);
                }
                if (iMicroDocument != null) {
                    this.onBetweenReadAndWAL(iMicroDocument);
                }
                File file3 = stopWatch = (object = this._getWALFilename()) == null ? null : this.m_aIO.getFile((String)object);
                if (stopWatch == null || !stopWatch.exists()) break block69;
                if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("Trying to recover from WAL file " + stopWatch.getAbsolutePath());
                }
                boolean bl2 = false;
                boolean bl3 = false;
                try (DataInputStream dataInputStream = new DataInputStream(FileHelper.getInputStream((File)stopWatch));){
                    block35: while (true) {
                        String string2;
                        try {
                            string2 = StreamHelper.readSafeUTF((DataInput)dataInputStream);
                        }
                        catch (EOFException eOFException) {
                            break;
                        }
                        EDAOActionType eDAOActionType = EDAOActionType.getFromIDOrThrow(string2);
                        int n = dataInputStream.readInt();
                        if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                            LOGGER.info("Trying to recover " + n + " " + (Object)((Object)eDAOActionType) + " actions from WAL file");
                        }
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block35;
                            String string3 = StreamHelper.readSafeUTF((DataInput)dataInputStream);
                            DATATYPE DATATYPE = this.convertWALStringToNative(string3);
                            if (DATATYPE == null) {
                                bl3 = true;
                                this.onRecoveryErrorConvertToNative(eDAOActionType, n2, string3);
                            } else {
                                if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                                    LOGGER.info("Trying to recover object [" + n2 + "] with " + string3.length() + " chars");
                                }
                                switch (eDAOActionType) {
                                    case CREATE: {
                                        try {
                                            this.onRecoveryCreate(DATATYPE);
                                            bl2 = true;
                                            if (AbstractWALDAO.isSilentMode() || !LOGGER.isInfoEnabled()) break;
                                            LOGGER.info("[WAL] wal-recovery create " + DATATYPE);
                                            break;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            if (LOGGER.isErrorEnabled()) {
                                                LOGGER.error("[WAL] wal-recovery create " + DATATYPE + " - " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
                                            }
                                            throw runtimeException;
                                        }
                                    }
                                    case UPDATE: {
                                        try {
                                            this.onRecoveryUpdate(DATATYPE);
                                            bl2 = true;
                                            if (AbstractWALDAO.isSilentMode() || !LOGGER.isInfoEnabled()) break;
                                            LOGGER.info("[WAL] wal-recovery update " + DATATYPE);
                                            break;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            if (LOGGER.isErrorEnabled()) {
                                                LOGGER.error("[WAL] wal-recovery update " + DATATYPE + " - " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
                                            }
                                            throw runtimeException;
                                        }
                                    }
                                    case DELETE: {
                                        try {
                                            this.onRecoveryDelete(DATATYPE);
                                            bl2 = true;
                                            if (AbstractWALDAO.isSilentMode() || !LOGGER.isInfoEnabled()) break;
                                            LOGGER.info("[WAL] wal-recovery delete " + DATATYPE);
                                            break;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            if (LOGGER.isErrorEnabled()) {
                                                LOGGER.error("[WAL] wal-recovery delete " + DATATYPE + " - " + runtimeException.getClass().getName() + ": " + runtimeException.getMessage());
                                            }
                                            throw runtimeException;
                                        }
                                    }
                                    default: {
                                        throw new IllegalStateException("Unsupported action type provided: " + (Object)((Object)eDAOActionType));
                                    }
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                    if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Successfully finished recovery from WAL file " + stopWatch.getAbsolutePath());
                    }
                }
                catch (IOException | RuntimeException exception) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("Failed to recover from WAL file '" + stopWatch.getAbsolutePath() + "'. Technical details: " + exception.getClass().getName() + ": " + exception.getMessage());
                    }
                    AbstractWALDAO.triggerExceptionHandlersRead(exception, false, (File)stopWatch);
                    throw new DAOException("Error the WAL file '" + stopWatch.getAbsolutePath() + "'", exception);
                }
                if (bl2) {
                    this._writeToFileAndResetPendingChanges("onRecovery");
                }
                if (bl3) {
                    this._maintainWALFileAfterProcessing((String)object);
                } else {
                    this._deleteWALFileAfterProcessing((String)object);
                }
            }
            finally {
                this.m_bCanWriteWAL = true;
                this.m_aRWLock.writeLock().unlock();
            }
        }
    }

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void onFilenameChange(@Nullable String string, @Nonnull String string2) {
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    protected abstract IMicroDocument createWriteData();

    @OverrideOnDemand
    @MustBeLocked(value=ELockType.WRITE)
    protected void modifyWriteData(@Nonnull IMicroDocument iMicroDocument) {
        MicroComment microComment = new MicroComment((CharSequence)("This file was generated automatically - do NOT modify!\nWritten at " + PDTToString.getAsString((ZonedDateTime)ZonedDateTime.now(Clock.systemUTC()), (Locale)Locale.US)));
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement();
        if (iMicroElement != null) {
            iMicroDocument.insertBefore((IMicroNode)microComment, (IMicroNode)iMicroElement);
        } else {
            iMicroDocument.appendChild((IMicroNode)microComment);
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IXMLWriterSettings getXMLWriterSettings() {
        return WRITE_XWS;
    }

    @Nullable
    public final String getLastFilename() {
        return (String)this.m_aRWLock.readLockedGet(() -> this.m_sPreviousFilename);
    }

    protected static void triggerExceptionHandlersWrite(@Nonnull Throwable throwable, @Nonnull String string, @Nullable IMicroDocument iMicroDocument) {
        if (AbstractWALDAO.exceptionHandlersWrite().isNotEmpty()) {
            FileSystemResource fileSystemResource = new FileSystemResource(string);
            String string2 = iMicroDocument == null ? "no XML document created" : MicroWriter.getNodeAsString((IMicroNode)iMicroDocument);
            AbstractWALDAO.exceptionHandlersWrite().forEach(arg_0 -> AbstractWALDAO.lambda$triggerExceptionHandlersWrite$2(throwable, (IReadableResource)fileSystemResource, string2, arg_0));
        }
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    @MustBeLocked(value=ELockType.WRITE)
    private ESuccess _writeToFile() {
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
                LOGGER.info("The DAO of class " + this.getClass().getName() + " cannot write to a file");
            }
            return ESuccess.FAILURE;
        }
        if (!string.equals(this.m_sPreviousFilename)) {
            this.onFilenameChange(this.m_sPreviousFilename, string);
            this.m_sPreviousFilename = string;
        }
        if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Trying to write WAL DAO file '" + string + "'");
        }
        File file = null;
        IMicroDocument iMicroDocument = null;
        String string2 = AbstractWALDAO._getFilenameNew(string);
        String string3 = AbstractWALDAO._getFilenamePrev(string);
        try {
            FileIOError fileIOError;
            file = this.getSafeFile(string2, IDAO.EMode.WRITE);
            this.m_aStatsCounterWriteTotal.increment();
            StopWatch stopWatch = StopWatch.createdStarted();
            iMicroDocument = this.createWriteData();
            if (iMicroDocument == null) {
                throw new DAOException("Failed to create data to write to file");
            }
            this.modifyWriteData(iMicroDocument);
            FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
            if (fileOutputStream == null) {
                throw new DAOException("Failed to open output stream for '" + file.getAbsolutePath() + "'");
            }
            IXMLWriterSettings iXMLWriterSettings = this.getXMLWriterSettings();
            if (MicroWriter.writeToStream((IMicroNode)iMicroDocument, (OutputStream)fileOutputStream, (IXMLWriterSettings)iXMLWriterSettings).isFailure()) {
                throw new DAOException("Failed to write DAO XML data to file");
            }
            boolean bl = false;
            if (this.m_aIO.existsFile(string)) {
                fileIOError = this.m_aIO.renameFile(string, string3);
                bl = true;
            } else {
                fileIOError = new FileIOError(EFileIOOperation.RENAME_FILE, EFileIOErrorCode.NO_ERROR);
            }
            if (fileIOError.isSuccess()) {
                fileIOError = this.m_aIO.renameFile(string2, string);
                if (fileIOError.isSuccess()) {
                    fileIOError = this.m_aIO.deleteFileIfExisting(string3);
                } else if (bl) {
                    this.m_aIO.renameFile(string3, string);
                }
            }
            if (fileIOError.isFailure()) {
                throw new IllegalStateException("Error on rename(existing-old)/rename(new-existing)/delete(old): " + fileIOError);
            }
            this.m_aStatsCounterWriteTimer.addTime(stopWatch.stopAndGetMillis());
            this.m_aStatsCounterWriteSuccess.increment();
            ++this.m_nWriteCount;
            this.m_aLastWriteDT = PDTFactory.getCurrentLocalDateTime();
            return ESuccess.SUCCESS;
        }
        catch (DAOException | RuntimeException exception) {
            String string4;
            String string5 = string4 = file != null ? file.getAbsolutePath() : string;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The DAO of class " + this.getClass().getName() + " failed to write the DAO data to '" + string4 + "'", (Throwable)exception);
            }
            AbstractWALDAO.triggerExceptionHandlersWrite(exception, string4, iMicroDocument);
            this.m_aStatsCounterWriteExceptions.increment();
            return ESuccess.FAILURE;
        }
    }

    @MustBeLocked(value=ELockType.WRITE)
    final void _writeToFileAndResetPendingChanges(@Nonnull String string) {
        if (this._writeToFile().isSuccess()) {
            this.internalSetPendingChanges(false);
        } else if (LOGGER.isErrorEnabled()) {
            LOGGER.error("The DAO of class " + this.getClass().getName() + " still has pending changes after " + string + "!");
        }
    }

    @Nullable
    private String _getWALFilename() {
        String string = this.m_aFilenameProvider.get();
        if (string == null) {
            return null;
        }
        return string + ".wal";
    }

    final void _maintainWALFileAfterProcessing(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"WALFilename");
        File file = this.m_aIO.getFile(string);
        File file2 = new File(file.getParentFile(), file.getName() + "." + PDTFactory.getCurrentMillis() + ".bup");
        if (FileOperationManager.INSTANCE.renameFile(file, file2).isFailure()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to rename WAL file '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'");
            }
        } else if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Maintained WAL file '" + file.getAbsolutePath() + "' as '" + file2.getAbsolutePath() + "' for debugging purposes");
        }
    }

    final void _deleteWALFileAfterProcessing(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"WALFilename");
        File file = this.m_aIO.getFile(string);
        if (FileOperationManager.INSTANCE.deleteFile(file).isFailure()) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to delete WAL file '" + file.getAbsolutePath() + "'");
            }
        } else if (!AbstractWALDAO.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Deleted successfully imported WAL file '" + file.getAbsolutePath() + "'");
        }
    }

    @Nonnull
    @OverrideOnDemand
    protected IXMLWriterSettings getWALXMLWriterSettings() {
        return WAL_XWS;
    }

    @Nonnull
    @OverrideOnDemand
    protected String convertNativeToWALString(@Nonnull DATATYPE DATATYPE) {
        IMicroElement iMicroElement = MicroTypeConverter.convertToMicroElement(DATATYPE, (String)"item");
        if (iMicroElement == null) {
            throw new IllegalStateException("Failed to convert " + DATATYPE + " of class " + DATATYPE.getClass().getName() + " to XML!");
        }
        return MicroWriter.getNodeAsString((IMicroNode)iMicroElement, (IXMLWriterSettings)this.getWALXMLWriterSettings());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    private ESuccess _writeWALFile(@Nonnull @Nonempty List<DATATYPE> list, @Nonnull EDAOActionType eDAOActionType, @Nonnull @Nonempty String string) {
        FileSystemResource fileSystemResource = this.m_aIO.getResource(string);
        try (DataOutputStream dataOutputStream = new DataOutputStream(fileSystemResource.getOutputStream(EAppend.APPEND));){
            StreamHelper.writeSafeUTF((DataOutput)dataOutputStream, (String)eDAOActionType.getID());
            dataOutputStream.writeInt(list.size());
            for (DATATYPE DATATYPE : list) {
                String string2 = this.convertNativeToWALString(DATATYPE);
                StreamHelper.writeSafeUTF((DataOutput)dataOutputStream, (String)string2);
            }
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (Exception exception) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Error writing WAL file " + fileSystemResource, (Throwable)exception);
            }
            AbstractWALDAO.triggerExceptionHandlersWrite(exception, string, null);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public Duration getWaitingTime() {
        return this.m_aWaitingTime;
    }

    protected void setWaitingTime(@Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"WaitingTime");
        this.m_aWaitingTime = duration;
    }

    @OverridingMethodsMustInvokeSuper
    @MustBeLocked(value=ELockType.WRITE)
    protected void markAsChanged(@Nonnull DATATYPE DATATYPE, @Nonnull EDAOActionType eDAOActionType) {
        ValueEnforcer.notNull(DATATYPE, (String)"ModifiedElement");
        ValueEnforcer.notNull((Object)((Object)eDAOActionType), (String)"ActionType");
        this.markAsChanged((List<DATATYPE>)new CommonsArrayList(DATATYPE), eDAOActionType);
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected final void markAsChanged(@Nonnull List<DATATYPE> list, @Nonnull EDAOActionType eDAOActionType) {
        ValueEnforcer.notNull(list, (String)"ModifiedElements");
        ValueEnforcer.notNull((Object)((Object)eDAOActionType), (String)"ActionType");
        this.internalSetPendingChanges(true);
        if (this.internalIsAutoSaveEnabled()) {
            String string = this._getWALFilename();
            if (this.m_bCanWriteWAL && this.m_aWaitingTime.compareTo(Duration.ZERO) > 0 && string != null && this._writeWALFile(list, eDAOActionType, string).isSuccess()) {
                this.m_aWALListener.registerForLaterWriting(this, string, this.m_aWaitingTime);
            } else {
                this._writeToFileAndResetPendingChanges("markAsChanged(" + eDAOActionType.getID() + ")");
            }
        }
    }

    @Override
    public final void writeToFileOnPendingChanges() {
        if (this.hasPendingChanges()) {
            this.m_aRWLock.writeLocked(() -> this._writeToFileAndResetPendingChanges("writeToFileOnPendingChanges"));
        }
    }

    @Override
    @Nonnegative
    public int getInitCount() {
        return this.m_nInitCount;
    }

    @Override
    @Nullable
    public final LocalDateTime getLastInitDateTime() {
        return this.m_aLastInitDT;
    }

    @Override
    @Nonnegative
    public int getReadCount() {
        return this.m_nReadCount;
    }

    @Override
    @Nullable
    public final LocalDateTime getLastReadDateTime() {
        return this.m_aLastReadDT;
    }

    @Override
    @Nonnegative
    public int getWriteCount() {
        return this.m_nWriteCount;
    }

    @Override
    @Nullable
    public final LocalDateTime getLastWriteDateTime() {
        return this.m_aLastWriteDT;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("FilenameProvider", this.m_aFilenameProvider).append("PreviousFilename", (Object)this.m_sPreviousFilename).append("InitCount", this.m_nInitCount).appendIfNotNull("LastInitDT", (Object)this.m_aLastInitDT).append("ReadCount", this.m_nReadCount).appendIfNotNull("LastReadDT", (Object)this.m_aLastReadDT).append("WriteCount", this.m_nWriteCount).appendIfNotNull("LastWriteDT", (Object)this.m_aLastWriteDT).getToString();
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersWrite$2(Throwable throwable, IReadableResource iReadableResource, String string, IDAOWriteExceptionCallback iDAOWriteExceptionCallback) {
        iDAOWriteExceptionCallback.onDAOWriteException(throwable, iReadableResource, string);
    }

    private static /* synthetic */ void lambda$triggerExceptionHandlersRead$0(Throwable throwable, boolean bl, IReadableResource iReadableResource, IDAOReadExceptionCallback iDAOReadExceptionCallback) {
        iDAOReadExceptionCallback.onDAOReadException(throwable, bl, iReadableResource);
    }
}

