/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.sysprop;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.system.SystemProperties;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.config.source.AbstractConfigurationSource;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.IIterableConfigurationSource;
import com.helger.config.value.ConfiguredValue;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class ConfigurationSourceSystemProperty
extends AbstractConfigurationSource
implements IIterableConfigurationSource {
    public static final EConfigSourceType SOURCE_TYPE = EConfigSourceType.SYSTEM_PROPERTY;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceSystemProperty.class);

    public ConfigurationSourceSystemProperty() {
        this(SOURCE_TYPE.getDefaultPriority());
    }

    public ConfigurationSourceSystemProperty(int n) {
        super(SOURCE_TYPE, n);
    }

    @Override
    public boolean isInitializedAndUsable() {
        return true;
    }

    @Override
    public @Nullable ConfiguredValue getConfigurationValue(@NonNull @Nonempty String string) {
        String string2;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Querying configuration property '" + string + "' as SystemProperty");
        }
        if ((string2 = SystemProperties.getPropertyValueOrNull((String)string)) == null) {
            return null;
        }
        if (ConfigurationSourceSystemProperty.hasTrailingWhitespace(string2)) {
            LOGGER.warn("The value of the system property '" + string + "' has a trailing whitespace. This may lead to unintended side effects.");
        }
        return new ConfiguredValue(this, string2);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsMap<String, String> getAllConfigItems() {
        return new CommonsTreeMap((Map)SystemProperties.getAllProperties());
    }
}

