/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.resource.properties;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.rt.NonBlockingProperties;
import com.helger.base.state.ESuccess;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.config.source.resource.AbstractConfigurationSourceResource;
import com.helger.config.value.ConfiguredValue;
import com.helger.io.resource.IReadableResource;
import com.helger.io.rt.PropertiesLoader;
import java.nio.charset.Charset;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConfigurationSourceProperties
extends AbstractConfigurationSourceResource {
    public static final String FILE_EXT = "properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceProperties.class);
    private final Charset m_aCharset;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private NonBlockingProperties m_aProps;

    private static @Nullable NonBlockingProperties _load(@NonNull IReadableResource iReadableResource, @Nullable Charset charset) {
        if (charset == null) {
            return PropertiesLoader.loadProperties((IReadableResource)iReadableResource);
        }
        return PropertiesLoader.loadProperties((IReadableResource)iReadableResource, (Charset)charset);
    }

    public ConfigurationSourceProperties(@NonNull IReadableResource iReadableResource) {
        this(CONFIG_SOURCE_TYPE.getDefaultPriority(), iReadableResource, null);
    }

    public ConfigurationSourceProperties(@NonNull IReadableResource iReadableResource, @Nullable Charset charset) {
        this(CONFIG_SOURCE_TYPE.getDefaultPriority(), iReadableResource, charset);
    }

    public ConfigurationSourceProperties(int n, @NonNull IReadableResource iReadableResource) {
        this(n, iReadableResource, null);
    }

    public ConfigurationSourceProperties(int n, @NonNull IReadableResource iReadableResource, @Nullable Charset charset) {
        super(n, iReadableResource);
        this.m_aCharset = charset;
        this.m_aProps = ConfigurationSourceProperties._load(iReadableResource, charset);
        if (this.m_aProps != null) {
            for (Map.Entry entry : this.m_aProps.entrySet()) {
                if (!ConfigurationSourceProperties.hasTrailingWhitespace((String)entry.getValue())) continue;
                LOGGER.warn("The value of the configuration property '" + (String)entry.getKey() + "' has a trailing whitespace. This may lead to unintended side effects.");
            }
        }
    }

    public @Nullable Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    public boolean isInitializedAndUsable() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aProps != null);
    }

    @Override
    public @NonNull ESuccess reload() {
        NonBlockingProperties nonBlockingProperties = ConfigurationSourceProperties._load(this.getResource(), this.m_aCharset);
        this.m_aRWLock.writeLocked(() -> {
            this.m_aProps = nonBlockingProperties;
        });
        return ESuccess.valueOf((nonBlockingProperties != null ? 1 : 0) != 0);
    }

    @Override
    public @Nullable ConfiguredValue getConfigurationValue(@Nonempty @NonNull String string) {
        String string2 = (String)this.m_aRWLock.readLockedGet(() -> this.m_aProps == null ? null : (String)this.m_aProps.get((Object)string));
        return string2 == null ? null : new ConfiguredValue(this, string2);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<String, String> getAllConfigItems() {
        return (ICommonsOrderedMap)this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashMap((Map)this.m_aProps));
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Properties", (Object)ConfigurationSourceProperties.mapToStringIgnoreSecrets(this.m_aProps)).getToString();
    }
}

