/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.fallback;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.config.Config;
import com.helger.config.fallback.IConfigKeyOutdatedNotifier;
import com.helger.config.fallback.IConfigWithFallback;
import com.helger.config.value.ConfiguredValue;
import com.helger.config.value.IConfigurationValueProvider;
import java.math.BigDecimal;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigWithFallback
extends Config
implements IConfigWithFallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigWithFallback.class);
    public static final IConfigKeyOutdatedNotifier DEFAULT_OUTDATED_NOTIFIER = (string, string2) -> LOGGER.warn("Please rename the configuration property '" + string + "' to '" + string2 + "'. The old name is deprecated.");
    private IConfigKeyOutdatedNotifier m_aOutdatedNotifier = DEFAULT_OUTDATED_NOTIFIER;

    public ConfigWithFallback(@NonNull IConfigurationValueProvider iConfigurationValueProvider) {
        super(iConfigurationValueProvider);
    }

    public final @NonNull IConfigKeyOutdatedNotifier getOutdatedNotifier() {
        return this.m_aOutdatedNotifier;
    }

    public final @NonNull ConfigWithFallback setOutdatedNotifier(@NonNull IConfigKeyOutdatedNotifier iConfigKeyOutdatedNotifier) {
        ValueEnforcer.notNull((Object)iConfigKeyOutdatedNotifier, (String)"OutdatedNotifier");
        this.m_aOutdatedNotifier = iConfigKeyOutdatedNotifier;
        return this;
    }

    @Override
    public @Nullable ConfiguredValue getConfiguredValueOrFallback(@NonNull String string, String ... stringArray) {
        ConfiguredValue configuredValue = this.getConfiguredValue(string);
        if (configuredValue == null) {
            for (String string2 : stringArray) {
                configuredValue = this.getConfiguredValue(string2);
                if (configuredValue == null) continue;
                this.m_aOutdatedNotifier.onOutdatedConfigurationKey(string2, string);
                break;
            }
        }
        return configuredValue;
    }

    @Override
    public @Nullable String getAsStringOrFallback(@NonNull String string, String ... stringArray) {
        String string2 = this.getAsString(string);
        if (StringHelper.isEmpty((String)string2)) {
            for (String string3 : stringArray) {
                string2 = this.getAsString(string3);
                if (!StringHelper.isNotEmpty((String)string2)) continue;
                this.m_aOutdatedNotifier.onOutdatedConfigurationKey(string3, string);
                break;
            }
        }
        return string2;
    }

    @Override
    public @Nullable char[] getAsCharArrayOrFallback(@NonNull String string, String ... stringArray) {
        char[] cArray = this.getAsCharArray(string);
        if (cArray == null) {
            for (String string2 : stringArray) {
                cArray = this.getAsCharArray(string2);
                if (cArray == null) continue;
                this.m_aOutdatedNotifier.onOutdatedConfigurationKey(string2, string);
                break;
            }
        }
        return cArray;
    }

    @Override
    public @Nullable BigDecimal getAsBigDecimalOrFallback(@NonNull String string, String ... stringArray) {
        BigDecimal bigDecimal = this.getAsBigDecimal(string);
        if (bigDecimal == null) {
            for (String string2 : stringArray) {
                bigDecimal = this.getAsBigDecimal(string2);
                if (bigDecimal == null) continue;
                this.m_aOutdatedNotifier.onOutdatedConfigurationKey(string2, string);
                break;
            }
        }
        return bigDecimal;
    }

    @Override
    public int getAsIntOrFallback(@NonNull String string, int n, int n2, String ... stringArray) {
        int n3 = this.getAsInt(string, n);
        if (n3 == n) {
            for (String string2 : stringArray) {
                n3 = this.getAsInt(string2, n);
                if (n3 == n) continue;
                this.m_aOutdatedNotifier.onOutdatedConfigurationKey(string2, string);
                break;
            }
        }
        return n3 == n ? n2 : n3;
    }

    @Override
    public long getAsLongOrFallback(@NonNull String string, long l, long l2, String ... stringArray) {
        long l3 = this.getAsLong(string, l);
        if (l3 == l) {
            for (String string2 : stringArray) {
                l3 = this.getAsLong(string2, l);
                if (l3 == l) continue;
                this.m_aOutdatedNotifier.onOutdatedConfigurationKey(string2, string);
                break;
            }
        }
        return l3 == l ? l2 : l3;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("OutdatedNotifier", (Object)this.m_aOutdatedNotifier).getToString();
    }
}

