/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.envvar;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class EnvVarHelper {
    public static final char DEFAULT_REPLACEMENT_CHAR = '_';

    private EnvVarHelper() {
    }

    public static boolean isValidFirstChar(char c) {
        return c >= 'A' && c <= 'Z' || c == '_';
    }

    public static boolean isValidFollowingChar(char c) {
        return EnvVarHelper.isValidFirstChar(c) || c >= '0' && c <= '9';
    }

    @Nullable
    public static String getUnifiedSysEnvName(@Nonnull @Nonempty String string, char c) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        for (char c2 : string.toCharArray()) {
            char c3 = Character.toUpperCase(c2);
            boolean bl = n == 0 ? EnvVarHelper.isValidFirstChar(c3) : EnvVarHelper.isValidFollowingChar(c3);
            stringBuilder.append(bl ? c3 : c);
            ++n;
        }
        return stringBuilder.toString();
    }
}

