/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.jmx;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.string.StringReplace;
import java.util.Hashtable;
import java.util.Map;
import javax.management.JMException;
import javax.management.ObjectName;
import org.jspecify.annotations.NonNull;

@ThreadSafe
public final class ObjectNameHelper {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static String s_sDefaultJMXDomain = "com.helger";
    private static final ObjectNameHelper INSTANCE = new ObjectNameHelper();

    private ObjectNameHelper() {
    }

    public static void setDefaultJMXDomain(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DefaultJMXDomain");
        ValueEnforcer.isFalse((string.indexOf(58) >= 0 || string.indexOf(32) >= 0 ? 1 : 0) != 0, () -> "defaultJMXDomain contains invalid chars: " + string);
        RW_LOCK.writeLocked(() -> {
            s_sDefaultJMXDomain = string;
        });
    }

    @Nonempty
    public static @NonNull String getDefaultJMXDomain() {
        return (String)RW_LOCK.readLockedGet(() -> s_sDefaultJMXDomain);
    }

    public static @NonNull ObjectName create(@Nonempty @NonNull Hashtable<String, String> hashtable) {
        ValueEnforcer.notEmpty(hashtable, (String)"Params");
        try {
            return new ObjectName(ObjectNameHelper.getDefaultJMXDomain(), hashtable);
        }
        catch (JMException jMException) {
            throw new IllegalArgumentException("Failed to create ObjectName with parameter " + String.valueOf(hashtable), jMException);
        }
    }

    public static @NonNull ObjectName create(@Nonempty @NonNull Map<String, String> map) {
        ValueEnforcer.notEmpty(map, (String)"Params");
        return ObjectNameHelper.create(new Hashtable<String, String>(map));
    }

    public static @NonNull String getCleanPropertyValue(@NonNull String string) {
        if (string.indexOf(32) != -1) {
            return ObjectName.quote(string);
        }
        String string2 = string;
        string2 = StringReplace.replaceAll((String)string2, (char)':', (char)'.');
        string2 = StringReplace.replaceAll((String)string2, (char)',', (char)'.');
        string2 = StringReplace.replaceAll((String)string2, (String)"//", (CharSequence)"__");
        return string2;
    }

    public static @NonNull ObjectName createWithDefaultProperties(@NonNull Object object) {
        ValueEnforcer.notNull((Object)object, (String)"Object");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", ClassHelper.getClassLocalName((Object)object));
        return ObjectNameHelper.create(hashtable);
    }

    public static @NonNull ObjectName createWithDefaultProperties(@NonNull Object object, @NonNull String string) {
        ValueEnforcer.notNull((Object)object, (String)"Object");
        ValueEnforcer.notNull((Object)string, (String)"Name");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("type", ClassHelper.getClassLocalName((Object)object));
        hashtable.put("name", ObjectNameHelper.getCleanPropertyValue(string));
        return ObjectNameHelper.create(hashtable);
    }
}

