/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringParser;
import com.helger.base.string.StringRemove;
import com.helger.base.system.SystemProperties;
import com.helger.datetime.format.PDTFromString;
import com.helger.datetime.helper.PDTFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Month;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JavaVersionHelper {
    public static final int JAVA_MAJOR_VERSION;
    public static final int JAVA_MINOR_VERSION;
    public static final int JAVA_MICRO_VERSION;
    private static final Logger LOGGER;
    private static final LocalDateTime REFERENCE_DATE;
    private static final LocalDateTime ADOPTOPENJDK_BUILD_172;
    private static final JavaVersionHelper INSTANCE;

    @Nonnull
    @ReturnsMutableCopy
    static int[] getAsUnifiedVersion(@Nonnull String string) {
        return JavaVersionHelper.getAsUnifiedVersion(string, SystemProperties.getJavaRuntimeVersion(), true);
    }

    @Nonnull
    @ReturnsMutableCopy
    static int[] getAsUnifiedVersion(@Nonnull String string, @Nullable String string2, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string3 = string;
        if (string3.startsWith("1.")) {
            int n4 = (string3 = string3.substring(2)).indexOf(46);
            if (n4 < 0) {
                String string4 = "Unexpected Java version string '" + string + "'";
                if (bl) {
                    throw new IllegalStateException(string4);
                }
                LOGGER.warn(string4);
                n = 0;
                n2 = 0;
                n3 = 0;
            } else {
                int n5;
                n = StringParser.parseInt((String)string3.substring(0, n4), (int)-1);
                if (n < 0) {
                    String string5 = "Failed to determine Java major version from '" + string + "'";
                    if (bl) {
                        throw new IllegalStateException(string5);
                    }
                    LOGGER.warn(string5);
                    n = 0;
                }
                if ((n5 = string3.indexOf(95)) >= 0) {
                    n2 = StringParser.parseInt((String)string3.substring(n5 + 1), (int)-1);
                    if (n2 < 0) {
                        String string6 = "Failed to determine Java minor version from '" + string + "'";
                        if (bl) {
                            throw new IllegalStateException(string6);
                        }
                        LOGGER.warn(string6);
                        n2 = 0;
                    }
                    n3 = -1;
                } else {
                    int n6 = string3.indexOf(45);
                    if (n6 >= 0) {
                        if (string2.startsWith(string)) {
                            LocalDateTime localDateTime;
                            String string7 = string2.substring(string.length());
                            string7 = StringRemove.removeAll((String)string7, (char)'_');
                            int n7 = (string7 = StringRemove.removeAll((String)string7, (char)'-')).indexOf(98);
                            if (n7 >= 0) {
                                string7 = string7.substring(0, n7);
                            }
                            if ((localDateTime = PDTFromString.getLocalDateTimeFromString((String)string7, (String)"uuuuMMddHHmm")) != null) {
                                n2 = localDateTime.equals(ADOPTOPENJDK_BUILD_172) ? 172 : Math.toIntExact(Duration.between(REFERENCE_DATE, localDateTime).toMinutes());
                            } else {
                                LOGGER.warn("Unknown runtime version '" + string2 + "' compared to java version '" + string);
                                n2 = -1;
                                n3 = -1;
                            }
                        } else {
                            LOGGER.warn("Unknown runtime version '" + string2 + "' compared to java version '" + string);
                            n2 = -1;
                            n3 = -1;
                        }
                    } else {
                        String string8 = "Unexpected Java version string '" + string + "'";
                        if (bl) {
                            throw new IllegalStateException(string8);
                        }
                        LOGGER.warn(string8);
                        n = 0;
                        n2 = 0;
                        n3 = 0;
                    }
                }
            }
        } else {
            int n8;
            int n9;
            int n10 = string3.indexOf(45);
            if (n10 > 0) {
                string3 = string3.substring(0, n10);
            }
            if ((n9 = string3.indexOf(43)) > 0) {
                string3 = string3.substring(0, n9);
            }
            if ((n = (n8 = string3.indexOf(46)) < 0 ? StringParser.parseInt((String)string3, (int)-1) : StringParser.parseInt((String)string3.substring(0, n8), (int)-1)) < 0) {
                String string9 = "Failed to determine Java major version from '" + string + "'";
                if (bl) {
                    throw new IllegalStateException(string9);
                }
                LOGGER.warn(string9);
                n = 0;
            }
            if (n8 >= 0) {
                int n11;
                int n12 = string3.indexOf(46, n8 + 1);
                n2 = n12 < 0 ? StringParser.parseInt((String)string3.substring(n8 + 1), (int)-1) : StringParser.parseInt((String)string3.substring(n8 + 1, n12), (int)-1);
                if (n2 < 0) {
                    String string10 = "Failed to determine Java minor version from '" + string + "'";
                    if (bl) {
                        throw new IllegalStateException(string10);
                    }
                    LOGGER.warn(string10);
                    n2 = 0;
                }
                if (n12 >= 0 && (n3 = (n11 = string3.indexOf(46, n12 + 1)) < 0 ? StringParser.parseInt((String)string3.substring(n12 + 1), (int)-1) : StringParser.parseInt((String)string3.substring(n12 + 1, n11), (int)-1)) < 0) {
                    String string11 = "Failed to determine Java micro version from '" + string + "'";
                    if (bl) {
                        throw new IllegalStateException(string11);
                    }
                    LOGGER.warn(string11);
                    n3 = 0;
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Java version '" + string + "' split into " + n + "." + n2 + (String)(n3 >= 0 ? "." + n3 : ""));
        }
        return new int[]{n, n2, n3};
    }

    private JavaVersionHelper() {
    }

    public static boolean isAtLeast(int n, int n2) {
        if (JAVA_MAJOR_VERSION > n) {
            return true;
        }
        if (JAVA_MAJOR_VERSION == n) {
            return JAVA_MINOR_VERSION >= n2;
        }
        return false;
    }

    static {
        LOGGER = LoggerFactory.getLogger(JavaVersionHelper.class);
        REFERENCE_DATE = PDTFactory.createLocalDateTime((int)2018, (Month)Month.JANUARY, (int)1, (int)0, (int)0, (int)0);
        ADOPTOPENJDK_BUILD_172 = PDTFactory.createLocalDateTime((int)2018, (Month)Month.MAY, (int)19, (int)0, (int)59, (int)0);
        int[] nArray = JavaVersionHelper.getAsUnifiedVersion(SystemProperties.getJavaVersion(), SystemProperties.getJavaRuntimeVersion(), false);
        JAVA_MAJOR_VERSION = nArray[0];
        JAVA_MINOR_VERSION = nArray[1];
        JAVA_MICRO_VERSION = nArray[2];
        INSTANCE = new JavaVersionHelper();
    }
}

