/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.math;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

@Immutable
public final class RoundHelper {
    private static final RoundHelper INSTANCE = new RoundHelper();

    private RoundHelper() {
    }

    public static double getRounded(double d, @Nonnegative int n, @Nonnull RoundingMode roundingMode, @Nonnull EDecimalType eDecimalType) {
        double d2;
        ValueEnforcer.isGE0((int)n, (String)"Scale");
        ValueEnforcer.notNull((Object)((Object)roundingMode), (String)"RoundingMode");
        ValueEnforcer.notNull((Object)((Object)eDecimalType), (String)"Type");
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        if (eDecimalType.isExponential()) {
            BigDecimal bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue(), bigDecimal.precision() - 1);
            d2 = bigDecimal2.setScale(n, roundingMode).scaleByPowerOfTen(bigDecimal2.scale() - bigDecimal.scale()).doubleValue();
        } else {
            d2 = bigDecimal.setScale(n, roundingMode).doubleValue();
        }
        return d2;
    }

    public static double getRoundedUpFix(double d, @Nonnegative int n) {
        return RoundHelper.getRounded(d, n, RoundingMode.HALF_UP, EDecimalType.FIX);
    }

    public static double getRoundedUpFix2(double d) {
        return RoundHelper.getRoundedUpFix(d, 2);
    }

    public static double getRoundedEvenExp(double d, @Nonnegative int n) {
        return RoundHelper.getRounded(d, n, RoundingMode.HALF_EVEN, EDecimalType.EXP);
    }

    public static double getRoundedEvenExp2(double d) {
        return RoundHelper.getRoundedEvenExp(d, 2);
    }

    @Nonnull
    public static String getFormatted(double d, @Nonnegative int n, @Nonnull EDecimalType eDecimalType, @Nonnull Locale locale) {
        ValueEnforcer.isGE0((int)n, (String)"Scale");
        ValueEnforcer.notNull((Object)((Object)eDecimalType), (String)"Type");
        ValueEnforcer.notNull((Object)locale, (String)"Locale");
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(locale);
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(locale));
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setMinimumFractionDigits(n);
        if (eDecimalType.isExponential()) {
            StringBuilder stringBuilder = new StringBuilder("0E0");
            if (n > 0) {
                stringBuilder.append('.').append(StringHelper.getRepeated((char)'0', (int)n));
            }
            decimalFormat.applyPattern(stringBuilder.toString());
        } else {
            decimalFormat.setGroupingUsed(false);
            decimalFormat.setMinimumIntegerDigits(1);
        }
        return decimalFormat.format(d);
    }

    @Nonnull
    public static String getFormattedFix(double d, @Nonnegative int n, Locale locale) {
        return RoundHelper.getFormatted(d, n, EDecimalType.FIX, locale);
    }

    @Nonnull
    public static String getFormattedFix2(double d, Locale locale) {
        return RoundHelper.getFormattedFix(d, 2, locale);
    }

    @Nonnull
    public static String getFormattedExp(double d, @Nonnegative int n, Locale locale) {
        return RoundHelper.getFormatted(d, n, EDecimalType.EXP, locale);
    }

    @Nonnull
    public static String getFormattedExp2(double d, Locale locale) {
        return RoundHelper.getFormattedExp(d, 2, locale);
    }

    public static enum EDecimalType {
        FIX,
        EXP;


        public boolean isFixed() {
            return this == FIX;
        }

        public boolean isExponential() {
            return this == EXP;
        }
    }
}

