/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.equals;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UseDirectEqualsAndHashCode;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsWeakHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.equals.IEqualsImplementation;
import com.helger.commons.equals.IEqualsImplementationRegistrarSPI;
import com.helger.commons.equals.IEqualsImplementationRegistry;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.ClassHierarchyCache;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.state.EChange;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class EqualsImplementationRegistry
implements IEqualsImplementationRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(EqualsImplementationRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<Class<?>, IEqualsImplementation<?>> m_aMap = new CommonsWeakHashMap();
    private final AnnotationUsageCache m_aDirectEquals = new AnnotationUsageCache(UseDirectEqualsAndHashCode.class);
    private final ICommonsMap<String, Boolean> m_aImplementsEquals = new CommonsHashMap<String, Boolean>();

    private EqualsImplementationRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static EqualsImplementationRegistry getInstance() {
        EqualsImplementationRegistry equalsImplementationRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return equalsImplementationRegistry;
    }

    @Override
    public <T> void registerEqualsImplementation(@Nonnull Class<T> clazz, @Nonnull IEqualsImplementation<T> iEqualsImplementation) {
        ValueEnforcer.notNull(clazz, "Class");
        ValueEnforcer.notNull(iEqualsImplementation, "Implementation");
        if (clazz.equals(Object.class)) {
            throw new IllegalArgumentException("You cannot provide an equals implementation for Object.class!");
        }
        this.m_aRWLock.writeLocked(() -> {
            IEqualsImplementation iEqualsImplementation2 = (IEqualsImplementation)this.m_aMap.get(clazz);
            if (iEqualsImplementation2 == null) {
                this.m_aMap.put(clazz, iEqualsImplementation);
            } else if (EqualsHelper.identityDifferent(iEqualsImplementation2, iEqualsImplementation)) {
                LOGGER.warn("Another equals implementation for class " + String.valueOf(clazz) + " is already registered (" + iEqualsImplementation2.toString() + ") so it is not overwritten with " + iEqualsImplementation.toString());
            }
        });
    }

    @Nonnull
    public EChange unregisterEqualsImplementation(@Nonnull Class<?> clazz) {
        return this.m_aRWLock.writeLockedGet(() -> this.m_aMap.removeObject(clazz));
    }

    private boolean _isUseDirectEquals(@Nonnull Class<?> clazz) {
        return this.m_aDirectEquals.hasAnnotation(clazz);
    }

    private boolean _implementsEqualsItself(@Nonnull Class<?> clazz) {
        String string = clazz.getName();
        Boolean bl = this.m_aRWLock.readLockedGet(() -> (Boolean)this.m_aImplementsEquals.get(string));
        if (bl == null) {
            bl = this.m_aRWLock.writeLockedGet(() -> {
                Boolean bl = (Boolean)this.m_aImplementsEquals.get(string);
                if (bl == null) {
                    boolean bl2 = false;
                    try {
                        Method method = clazz.getDeclaredMethod("equals", Object.class);
                        if (method != null && method.getReturnType().equals(Boolean.TYPE)) {
                            bl2 = true;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    bl = bl2;
                    this.m_aImplementsEquals.put(string, bl);
                }
                return bl;
            });
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> IEqualsImplementation<T> getBestMatchingEqualsImplementation(@Nullable Class<T> clazz) {
        if (clazz != null) {
            Class clazz2;
            IEqualsImplementation iEqualsImplementation;
            block13: {
                iEqualsImplementation = null;
                clazz2 = null;
                if (this._isUseDirectEquals(clazz)) {
                    return null;
                }
                this.m_aRWLock.readLock().lock();
                try {
                    iEqualsImplementation = (IEqualsImplementation)GenericReflection.uncheckedCast((IEqualsImplementation)this.m_aMap.get(clazz));
                    if (iEqualsImplementation != null) {
                        clazz2 = clazz;
                        break block13;
                    }
                    for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator(clazz)) {
                        IEqualsImplementation iEqualsImplementation2;
                        Class clazz3 = (Class)weakReference.get();
                        if (clazz3 == null || (iEqualsImplementation2 = (IEqualsImplementation)this.m_aMap.get(clazz3)) == null) continue;
                        iEqualsImplementation = (IEqualsImplementation)GenericReflection.uncheckedCast(iEqualsImplementation2);
                        clazz2 = clazz3;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Found hierarchical match with class " + String.valueOf(clazz2) + " when searching for " + String.valueOf(clazz));
                        }
                        break;
                    }
                }
                finally {
                    this.m_aRWLock.readLock().unlock();
                }
            }
            if (iEqualsImplementation != null) {
                if (iEqualsImplementation.implementationEqualsOverridesInterface() && ClassHelper.isInterface(clazz2) && this._implementsEqualsItself(clazz)) {
                    this.m_aDirectEquals.setAnnotation(clazz, true);
                    return null;
                }
                if (!clazz2.equals(clazz)) {
                    this.registerEqualsImplementation(clazz, iEqualsImplementation);
                }
                return iEqualsImplementation;
            }
            if (ClassHelper.isArrayClass(clazz)) {
                return (IEqualsImplementation)GenericReflection.uncheckedCast(new ArrayEqualsImplementation());
            }
            this.m_aDirectEquals.setAnnotation(clazz, true);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Found no equals implementation for " + String.valueOf(clazz));
        }
        return null;
    }

    public static <T> boolean areEqual(@Nullable T t, @Nullable T t2) {
        Class<?> clazz;
        if (EqualsHelper.identityEqual(t, t2)) {
            return true;
        }
        if (t == null || t2 == null) {
            return false;
        }
        Class<?> clazz2 = t.getClass();
        if (!clazz2.equals(clazz = t2.getClass())) {
            return false;
        }
        IEqualsImplementation<T> iEqualsImplementation = EqualsImplementationRegistry.getInstance().getBestMatchingEqualsImplementation((Class)GenericReflection.uncheckedCast(clazz2));
        boolean bl = iEqualsImplementation == null ? t.equals(t2) : iEqualsImplementation.areEqual(t, t2);
        return bl;
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMap.clear();
            this.m_aDirectEquals.clearCache();
            this.m_aImplementsEquals.clear();
        });
        for (IEqualsImplementationRegistrarSPI iEqualsImplementationRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IEqualsImplementationRegistrarSPI.class)) {
            iEqualsImplementationRegistrarSPI.registerEqualsImplementations(this);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reinitialized " + EqualsImplementationRegistry.class.getName());
        }
    }

    private static final class SingletonHolder {
        private static final EqualsImplementationRegistry INSTANCE = new EqualsImplementationRegistry();

        private SingletonHolder() {
        }
    }

    private static final class ArrayEqualsImplementation
    implements IEqualsImplementation<Object[]> {
        private ArrayEqualsImplementation() {
        }

        @Override
        public boolean areEqual(@Nonnull Object[] objectArray, @Nonnull Object[] objectArray2) {
            int n = objectArray.length;
            if (n != objectArray2.length) {
                return false;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (EqualsImplementationRegistry.areEqual(objectArray[i], objectArray2[i])) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

