/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.codec.IEncoder;
import com.helger.commons.url.URLHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class URLParameterEncoder
implements IEncoder<String, String> {
    private final Charset m_aCharset;

    public URLParameterEncoder(@Nonnull Charset charset) {
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nullable
    public String getEncoded(@Nullable String string) {
        return string == null ? null : URLHelper.urlEncode(string, this.m_aCharset);
    }
}

