/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.Nonnegative;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NonNull;

public final class ArrayIteratorChar {
    private final char[] m_aArray;
    private int m_nIndex = 0;

    public ArrayIteratorChar(char ... cArray) {
        this(cArray, 0, cArray.length);
    }

    public ArrayIteratorChar(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen((char[])cArray, (int)n, (int)n2);
        this.m_aArray = ArrayHelper.getCopy((char[])cArray, (int)n, (int)n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public char next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorChar arrayIteratorChar = (ArrayIteratorChar)object;
        return EqualsHelper.equals((Object)this.m_aArray, (Object)arrayIteratorChar.m_aArray) && this.m_nIndex == arrayIteratorChar.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("array", (Object)Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).getToString();
    }
}

