/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.Nonnegative;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.base.IIterableIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ArrayIterator<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final ELEMENTTYPE[] m_aArray;
    private int m_nIndex = 0;

    @SafeVarargs
    public ArrayIterator(ELEMENTTYPE ... ELEMENTTYPEArray) {
        this(ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length);
    }

    public ArrayIterator(@NonNull ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen((Object[])ELEMENTTYPEArray, (int)n, (int)n2);
        this.m_aArray = ArrayHelper.getCopy((Object[])ELEMENTTYPEArray, (int)n, (int)n2);
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    public @Nullable ELEMENTTYPE next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIterator arrayIterator = (ArrayIterator)object;
        return EqualsHelper.equals(this.m_aArray, arrayIterator.m_aArray) && this.m_nIndex == arrayIterator.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object[])this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("array", (Object)Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).getToString();
    }
}

