/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsOrderedSet<ELEMENTTYPE>
extends ICommonsSet<ELEMENTTYPE> {
    @Override
    @ReturnsMutableCopy
    default public <T> @NonNull ICommonsOrderedSet<T> createInstance() {
        return new CommonsLinkedHashSet();
    }

    @Override
    @ReturnsMutableCopy
    default public @NonNull ICommonsOrderedSet<ELEMENTTYPE> getAll(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.getClone();
        }
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAll(predicate, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    @Override
    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsOrderedSet<DSTTYPE> getAllMapped(@NonNull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(function, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    @Override
    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsOrderedSet<DSTTYPE> getAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @NonNull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllMapped(predicate, function, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    @Override
    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> @NonNull ICommonsOrderedSet<DSTTYPE> getAllInstanceOf(@NonNull Class<DSTTYPE> clazz) {
        ICommonsSet iCommonsSet = this.createInstance();
        this.findAllInstanceOf(clazz, ((ICommonsOrderedSet)iCommonsSet)::add);
        return iCommonsSet;
    }

    default public @Nullable ELEMENTTYPE getFirst() {
        return this.getFirst(null);
    }

    default public @Nullable ELEMENTTYPE getFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(this.isEmpty() ? ELEMENTTYPE : this.iterator().next());
    }

    default public @Nullable ELEMENTTYPE getLast() {
        return this.getLast(null);
    }

    default public @Nullable ELEMENTTYPE getLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.isEmpty() ? ELEMENTTYPE : CollectionFind.getLastElement(this);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<ELEMENTTYPE> getClone();
}

