/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.queue;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.collection.CollectionFind;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.ICommonsIterableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class QueueHelper {
    private QueueHelper() {
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@Nonnegative int n) {
        return new PriorityQueue(n);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue() {
        return new PriorityQueue();
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> @NonNull PriorityQueue<DSTTYPE> newQueueMapped(@Nullable Collection<? extends SRCTYPE> collection, @NonNull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(collection.size());
        for (SRCTYPE SRCTYPE : collection) {
            priorityQueue.add((int)function.apply(SRCTYPE));
        }
        return priorityQueue;
    }

    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> @NonNull PriorityQueue<DSTTYPE> newQueueMapped(@Nullable SRCTYPE[] SRCTYPEArray, @NonNull Function<? super SRCTYPE, DSTTYPE> function) {
        if (ArrayHelper.isEmpty((Object[])SRCTYPEArray)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(SRCTYPEArray.length);
        for (SRCTYPE SRCTYPE : SRCTYPEArray) {
            priorityQueue.add((int)function.apply(SRCTYPE));
        }
        return priorityQueue;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@NonNull ELEMENTTYPE ELEMENTTYPE) {
        PriorityQueue<boolean> priorityQueue = QueueHelper.newQueue(true);
        priorityQueue.add((boolean)ELEMENTTYPE);
        return priorityQueue;
    }

    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty((Object[])ELEMENTTYPEArray)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(ELEMENTTYPEArray.length);
        Collections.addAll(priorityQueue, ELEMENTTYPEArray);
        return priorityQueue;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                priorityQueue.add(enumeration.nextElement());
            }
        }
        return priorityQueue;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (iterator != null) {
            while (iterator.hasNext()) {
                priorityQueue.add(iterator.next());
            }
        }
        return priorityQueue;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        PriorityQueue<ELEMENTTYPE> priorityQueue = QueueHelper.newQueue();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                priorityQueue.add(ELEMENTTYPE);
            }
        }
        return priorityQueue;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        return new PriorityQueue<ELEMENTTYPE>(collection);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> collection, @NonNull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return QueueHelper.newQueue(false);
        }
        PriorityQueue<int> priorityQueue = QueueHelper.newQueue(collection.size());
        CollectionFind.findAll(collection, predicate, priorityQueue::add);
        return priorityQueue;
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull PriorityQueue<ELEMENTTYPE> newQueue(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        if (iCommonsIterableIterator == null) {
            return QueueHelper.newQueue(false);
        }
        return QueueHelper.newQueue(iCommonsIterableIterator.iterator());
    }
}

