/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.Nonnegative;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NonNull;

public final class ArrayIteratorFloat {
    private final float[] m_aArray;
    private int m_nIndex = 0;

    public ArrayIteratorFloat(float ... fArray) {
        this(fArray, 0, fArray.length);
    }

    public ArrayIteratorFloat(@NonNull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen((float[])fArray, (int)n, (int)n2);
        this.m_aArray = ArrayHelper.getCopy((float[])fArray, (int)n, (int)n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public float next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorFloat arrayIteratorFloat = (ArrayIteratorFloat)object;
        return EqualsHelper.equals((Object)this.m_aArray, (Object)arrayIteratorFloat.m_aArray) && this.m_nIndex == arrayIteratorFloat.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("array", (Object)Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).getToString();
    }

    public static @NonNull ArrayIteratorFloat createOfsLen(@NonNull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        return new ArrayIteratorFloat(fArray, n, n2);
    }

    public static @NonNull ArrayIteratorFloat createBeginEnd(@NonNull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        return ArrayIteratorFloat.createOfsLen(fArray, n, n2 - n);
    }
}

