/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.enumeration;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class SingleElementEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private boolean m_bHasMoreElements = true;
    private final ELEMENTTYPE m_aElement;

    public SingleElementEnumeration(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_aElement = ELEMENTTYPE;
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_bHasMoreElements;
    }

    @Override
    public @Nullable ELEMENTTYPE nextElement() {
        if (this.m_bHasMoreElements) {
            this.m_bHasMoreElements = false;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleElementEnumeration singleElementEnumeration = (SingleElementEnumeration)object;
        return this.m_bHasMoreElements == singleElementEnumeration.m_bHasMoreElements && EqualsHelper.equals(this.m_aElement, singleElementEnumeration.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bHasMoreElements).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hasMoreElements", this.m_bHasMoreElements).append("element", this.m_aElement).getToString();
    }
}

