/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsIterableIterator;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsCollection<ELEMENTTYPE>
extends Collection<ELEMENTTYPE>,
ICommonsIterable<ELEMENTTYPE> {
    @Override
    @Nonnegative
    public int size();

    @Override
    public boolean isEmpty();

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<ELEMENTTYPE> getCopyAsList() {
        return new CommonsArrayList<ICommonsCollection>(this);
    }

    @Override
    @Nonnegative
    default public int getCount(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.getCount(this, predicate);
    }

    default public @Nullable ELEMENTTYPE getAtIndex(@Nonnegative int n) {
        return this.getAtIndex(n, null);
    }

    default public @Nullable ELEMENTTYPE getAtIndex(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionHelper.getAtIndex(this, n, ELEMENTTYPE);
    }

    default public @Nullable ELEMENTTYPE getAtIndex(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n) {
        return this.getAtIndex(predicate, n, null);
    }

    default public @Nullable ELEMENTTYPE getAtIndex(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionHelper.getAtIndex(this, predicate, n, ELEMENTTYPE);
    }

    default public <DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@Nonnegative int n, @NonNull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        return this.getAtIndexMapped(n, function, null);
    }

    default public <DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@Nonnegative int n, @NonNull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.getAtIndexMapped(this, n, function, DSTTYPE);
    }

    default public <DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@NonNull Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @NonNull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        return this.getAtIndexMapped(predicate, n, function, null);
    }

    default public <DSTTYPE> @Nullable DSTTYPE getAtIndexMapped(@NonNull Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @NonNull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.getAtIndexMapped(this, predicate, n, function, DSTTYPE);
    }

    default public @NonNull ICommonsList<ELEMENTTYPE> getSorted(@NonNull Comparator<? super ELEMENTTYPE> comparator) {
        return new CommonsArrayList<ICommonsCollection>(this).getSortedInline(comparator);
    }

    default public @NonNull EChange addObject(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return EChange.valueOf((boolean)this.add(ELEMENTTYPE));
    }

    default public @NonNull EChange addIf(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate != null && !predicate.test(ELEMENTTYPE)) {
            return EChange.UNCHANGED;
        }
        return this.addObject(ELEMENTTYPE);
    }

    default public @NonNull EChange addIfNotNull(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (ELEMENTTYPE == null) {
            return EChange.UNCHANGED;
        }
        return this.addObject(ELEMENTTYPE);
    }

    default public @NonNull EChange addAll(ELEMENTTYPE ... ELEMENTTYPEArray) {
        EChange eChange = EChange.UNCHANGED;
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public @NonNull EChange addAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public @NonNull EChange addAll(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        EChange eChange = EChange.UNCHANGED;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                eChange = eChange.or(this.add(enumeration.nextElement()));
            }
        }
        return eChange;
    }

    default public @NonNull EChange addAll(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        EChange eChange = EChange.UNCHANGED;
        if (iterator != null) {
            while (iterator.hasNext()) {
                eChange = eChange.or(this.add(iterator.next()));
            }
        }
        return eChange;
    }

    default public @NonNull EChange addAll(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(ELEMENTTYPEArray);
        }
        EChange eChange = EChange.UNCHANGED;
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public @NonNull EChange addAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(iterable);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public @NonNull EChange addAll(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(enumeration);
        }
        EChange eChange = EChange.UNCHANGED;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ELEMENTTYPE ELEMENTTYPE = enumeration.nextElement();
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public @NonNull EChange addAll(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.addAll(iterator);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterator != null) {
            while (iterator.hasNext()) {
                ELEMENTTYPE ELEMENTTYPE = iterator.next();
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public <SRCTYPE> @NonNull EChange addAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    default public <SRCTYPE> @NonNull EChange addAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        EChange eChange = EChange.UNCHANGED;
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    default public <SRCTYPE> @NonNull EChange addAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        if (predicate == null) {
            return this.addAllMapped(iterable, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                if (!predicate.test(SRCTYPE)) continue;
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    default public <SRCTYPE> @NonNull EChange addAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nullable Predicate<? super SRCTYPE> predicate, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        if (predicate == null) {
            return this.addAllMapped(SRCTYPEArray, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                if (!predicate.test(SRCTYPE)) continue;
                eChange = eChange.or(this.add(function.apply(SRCTYPE)));
            }
        }
        return eChange;
    }

    default public <SRCTYPE> @NonNull EChange addAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        if (predicate == null) {
            return this.addAllMapped(iterable, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                ELEMENTTYPE ELEMENTTYPE = function.apply(SRCTYPE);
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public <SRCTYPE> @NonNull EChange addAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        if (predicate == null) {
            return this.addAllMapped(SRCTYPEArray, function);
        }
        EChange eChange = EChange.UNCHANGED;
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                ELEMENTTYPE ELEMENTTYPE = function.apply(SRCTYPE);
                if (!predicate.test(ELEMENTTYPE)) continue;
                eChange = eChange.or(this.add(ELEMENTTYPE));
            }
        }
        return eChange;
    }

    default public @NonNull EChange set(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.removeAll().or(this.add(ELEMENTTYPE));
    }

    default public @NonNull EChange setAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return this.removeAll().or((IChangeIndicator)this.addAll(iterable));
    }

    default public @NonNull EChange setAll(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return this.removeAll().or((IChangeIndicator)this.addAll(ELEMENTTYPEArray));
    }

    default public <SRCTYPE> @NonNull EChange setAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        return this.removeAll().or((IChangeIndicator)this.addAllMapped(iterable, function));
    }

    default public <SRCTYPE> @NonNull EChange setAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        return this.removeAll().or((IChangeIndicator)this.addAllMapped(SRCTYPEArray, function));
    }

    default public @NonNull EChange removeAll() {
        if (this.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.clear();
        return EChange.CHANGED;
    }

    default public @NonNull EChange removeObject(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return EChange.valueOf((boolean)this.remove(ELEMENTTYPE));
    }

    @CodingStyleguideUnaware
    default public @NonNull Collection<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableCollection(this);
    }

    default public @NonNull ICommonsIterableIterator<ELEMENTTYPE> iterator2() {
        return new CommonsIterableIterator(this);
    }
}

