/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.enumeration;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.util.Enumeration;
import java.util.Iterator;

public final class EnumerationFromIterator<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aIter;

    public EnumerationFromIterator(@Nonnull Iterable<? extends ELEMENTTYPE> iterable) {
        this(iterable.iterator());
    }

    public EnumerationFromIterator(@Nonnull Iterator<? extends ELEMENTTYPE> iterator) {
        this.m_aIter = (Iterator)ValueEnforcer.notNull(iterator, (String)"Iterator");
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_aIter.hasNext();
    }

    @Override
    public ELEMENTTYPE nextElement() {
        return this.m_aIter.next();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("iter", this.m_aIter).getToString();
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterator<? extends ELEMENTTYPE> iterator) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterator);
    }

    @Nonnull
    public static <ELEMENTTYPE> EnumerationFromIterator<ELEMENTTYPE> create(@Nonnull Iterable<? extends ELEMENTTYPE> iterable) {
        return new EnumerationFromIterator<ELEMENTTYPE>(iterable);
    }
}

