/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.base.EmptyIterator;
import com.helger.collection.commons.ICommonsIterableIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Iterator;

public class CommonsIterableIterator<ELEMENTTYPE>
implements ICommonsIterableIterator<ELEMENTTYPE> {
    private static final CommonsIterableIterator<Object> EMPTY_ITERATOR = new CommonsIterableIterator(new EmptyIterator());
    private final Iterator<ELEMENTTYPE> m_aIter;

    public CommonsIterableIterator(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray) {
        this(Arrays.asList(ELEMENTTYPEArray));
    }

    public CommonsIterableIterator(@Nonnull Iterable<ELEMENTTYPE> iterable) {
        this(iterable.iterator());
    }

    public CommonsIterableIterator(@Nonnull Iterator<ELEMENTTYPE> iterator) {
        this.m_aIter = (Iterator)ValueEnforcer.notNull(iterator, (String)"Iterator");
    }

    @Override
    public final boolean hasNext() {
        return this.m_aIter.hasNext();
    }

    @Override
    @Nullable
    public final ELEMENTTYPE next() {
        return this.m_aIter.next();
    }

    @Override
    public final void remove() {
        this.m_aIter.remove();
    }

    @Override
    @Nonnull
    public final Iterator<ELEMENTTYPE> iterator() {
        return this.m_aIter;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Iter", this.m_aIter).getToString();
    }

    @Nonnull
    public static <ELEMENTTYPE> ICommonsIterableIterator<ELEMENTTYPE> createEmpty() {
        return (ICommonsIterableIterator)GenericReflection.uncheckedCast(EMPTY_ITERATOR);
    }
}

