/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.Nonnegative;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.NoSuchElementException;

public final class ArrayIteratorShort {
    private final short[] m_aArray;
    private int m_nIndex = 0;

    public ArrayIteratorShort(short ... sArray) {
        this(sArray, 0, sArray.length);
    }

    public ArrayIteratorShort(@Nonnull short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen((short[])sArray, (int)n, (int)n2);
        this.m_aArray = ArrayHelper.getCopy((short[])sArray, (int)n, (int)n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public short next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorShort arrayIteratorShort = (ArrayIteratorShort)object;
        return EqualsHelper.equals((Object)this.m_aArray, (Object)arrayIteratorShort.m_aArray) && this.m_nIndex == arrayIteratorShort.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("array", (Object)Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).getToString();
    }
}

