/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.ICommonsSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.SortedSet;

public interface ICommonsSortedSet<ELEMENTTYPE>
extends SortedSet<ELEMENTTYPE>,
ICommonsSet<ELEMENTTYPE> {
    @Override
    @Nullable
    default public ELEMENTTYPE getFirst() {
        return this.getFirst(null);
    }

    @Nullable
    default public ELEMENTTYPE getFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(this.isEmpty() ? ELEMENTTYPE : this.first());
    }

    @Override
    @Nullable
    default public ELEMENTTYPE getLast() {
        return this.getLast(null);
    }

    @Nullable
    default public ELEMENTTYPE getLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(this.isEmpty() ? ELEMENTTYPE : this.last());
    }

    @Override
    @Nonnull
    @CodingStyleguideUnaware
    default public SortedSet<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableSortedSet(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSortedSet<ELEMENTTYPE> getClone();
}

