/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@Immutable
public final class CollectionFind {
    private CollectionFind() {
    }

    public static <ELEMENTTYPE> boolean contains(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (CollectionHelper.isEmpty(collection)) {
            return false;
        }
        return collection.contains(ELEMENTTYPE);
    }

    public static <ELEMENTTYPE> boolean containsAny(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.isNotEmpty(iterable);
        }
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static <ELEMENTTYPE> boolean containsNone(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return CollectionHelper.isEmpty(iterable);
        }
        for (ELEMENTTYPE ELEMENTTYPE : iterable) {
            if (!predicate.test(ELEMENTTYPE)) continue;
            return false;
        }
        return true;
    }

    public static <ELEMENTTYPE> boolean containsOnly(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(iterable)) {
            return false;
        }
        if (predicate == null) {
            return CollectionHelper.isNotEmpty(iterable);
        }
        for (ELEMENTTYPE ELEMENTTYPE : iterable) {
            if (predicate.test(ELEMENTTYPE)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAnyNullElement(@Nullable Iterable<?> iterable) {
        return CollectionFind.containsAny(iterable, Objects::isNull);
    }

    public static boolean containsOnlyNullElements(@Nullable Iterable<?> iterable) {
        return CollectionFind.containsOnly(iterable, Objects::isNull);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable List<ELEMENTTYPE> list) {
        return CollectionHelper.isEmpty(list) ? null : (ELEMENTTYPE)list.get(0);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Collection<ELEMENTTYPE> collection) {
        return CollectionHelper.isEmpty(collection) ? null : (ELEMENTTYPE)collection.iterator().next();
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Iterable<ELEMENTTYPE> iterable) {
        return CollectionFind.getFirstElement(iterable, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        Iterator<ELEMENTTYPE> iterator;
        if (iterable != null && (iterator = iterable.iterator()).hasNext()) {
            return iterator.next();
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable List<ELEMENTTYPE> list) {
        int n = CollectionHelper.getSize(list);
        return n == 0 ? null : (ELEMENTTYPE)list.get(n - 1);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Collection<ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return null;
        }
        ELEMENTTYPE ELEMENTTYPE = null;
        for (ELEMENTTYPE ELEMENTTYPE2 : collection) {
            ELEMENTTYPE = ELEMENTTYPE2;
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Iterable<ELEMENTTYPE> iterable) {
        if (iterable == null) {
            return null;
        }
        ELEMENTTYPE ELEMENTTYPE = null;
        for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
            ELEMENTTYPE = ELEMENTTYPE2;
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE findFirst(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionFind.findFirst(iterable, predicate, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE findFirst(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (predicate == null) {
            return CollectionFind.getFirstElement(iterable, ELEMENTTYPE);
        }
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (ELEMENTTYPE ELEMENTTYPE2 : iterable) {
                if (!predicate.test(ELEMENTTYPE2)) continue;
                return ELEMENTTYPE2;
            }
        }
        return ELEMENTTYPE;
    }

    @Nullable
    public static <ELEMENTTYPE, DSTTYPE> DSTTYPE findFirstMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        return CollectionFind.findFirstMapped(iterable, predicate, function, null);
    }

    @Nullable
    public static <ELEMENTTYPE, DSTTYPE> DSTTYPE findFirstMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        if (CollectionHelper.isNotEmpty(iterable)) {
            if (predicate == null) {
                return function.apply(iterable.iterator().next());
            }
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                if (!predicate.test(ELEMENTTYPE)) continue;
                return function.apply(ELEMENTTYPE);
            }
        }
        return DSTTYPE;
    }

    public static <ELEMENTTYPE> void findAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (CollectionHelper.isNotEmpty(iterable)) {
            if (predicate == null) {
                iterable.forEach(consumer);
            } else {
                for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                    if (!predicate.test(ELEMENTTYPE)) continue;
                    consumer.accept(ELEMENTTYPE);
                }
            }
        }
    }

    public static <SRCTYPE, DSTTYPE> void findAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (CollectionHelper.isNotEmpty(iterable)) {
            for (SRCTYPE SRCTYPE : iterable) {
                consumer.accept(function.apply(SRCTYPE));
            }
        }
    }

    public static <SRCTYPE, DSTTYPE> void findAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nullable Predicate<? super SRCTYPE> predicate, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (predicate == null) {
            CollectionFind.findAllMapped(iterable, function, consumer);
        } else if (CollectionHelper.isNotEmpty(iterable)) {
            for (SRCTYPE SRCTYPE : iterable) {
                if (!predicate.test(SRCTYPE)) continue;
                consumer.accept(function.apply(SRCTYPE));
            }
        }
    }

    public static <SRCTYPE, DSTTYPE> void findAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends DSTTYPE> function, @Nullable Predicate<? super DSTTYPE> predicate, @Nonnull Consumer<? super DSTTYPE> consumer) {
        ValueEnforcer.notNull(function, (String)"Mapper");
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        if (predicate == null) {
            CollectionFind.findAllMapped(iterable, function, consumer);
        } else if (CollectionHelper.isNotEmpty(iterable)) {
            for (SRCTYPE SRCTYPE : iterable) {
                DSTTYPE DSTTYPE = function.apply(SRCTYPE);
                if (!predicate.test(DSTTYPE)) continue;
                consumer.accept(DSTTYPE);
            }
        }
    }
}

