/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.base.functional.IThrowingConsumer;
import com.helger.base.iface.IHasSize;
import com.helger.base.state.EContinue;
import com.helger.collection.CollectionFind;
import com.helger.collection.CollectionHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;

public interface ICommonsIterable<ELEMENTTYPE>
extends Iterable<ELEMENTTYPE>,
IHasSize {
    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public void forEachByIndex(@Nonnull ObjIntConsumer<? super ELEMENTTYPE> objIntConsumer) {
        int n = 0;
        for (Object t : this) {
            objIntConsumer.accept(t, n);
            ++n;
        }
    }

    @Nonnull
    default public EContinue forEachBreakable(@Nonnull Function<? super ELEMENTTYPE, EContinue> function) {
        Objects.requireNonNull(function);
        for (Object t : this) {
            if (!function.apply(t).isBreak()) continue;
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }

    default public <EXTYPE extends Throwable> void forEachThrowing(@Nonnull IThrowingConsumer<? super ELEMENTTYPE, EXTYPE> iThrowingConsumer) throws EXTYPE {
        for (Object t : this) {
            iThrowingConsumer.accept(t);
        }
    }

    default public void findAll(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        CollectionFind.findAll(this, predicate, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionFind.findAllMapped(this, function, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionFind.findAllMapped(this, predicate, function, consumer);
    }

    default public <DSTTYPE> void findAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable Predicate<? super DSTTYPE> predicate, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionFind.findAllMapped(this, function, predicate, consumer);
    }

    default public <DSTTYPE extends ELEMENTTYPE> void findAllInstanceOf(@Nonnull Class<DSTTYPE> clazz, @Nonnull Consumer<? super DSTTYPE> consumer) {
        this.findAllMapped(clazz::isInstance, clazz::cast, consumer);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return this.findFirst(predicate, null);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionFind.findFirst(this, predicate, ELEMENTTYPE);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        return this.findFirstMapped(predicate, function, null);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionFind.findFirstMapped(this, predicate, function, DSTTYPE);
    }

    default public boolean containsAny(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionFind.containsAny(this, predicate);
    }

    default public boolean containsNone(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionFind.containsNone(this, predicate);
    }

    default public boolean containsOnly(@Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionFind.containsOnly(this, predicate);
    }

    @Nonnegative
    default public int size() {
        return CollectionHelper.getSizeIterator(this.iterator());
    }

    @Nonnegative
    default public int getCount(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return this.size();
        }
        int n = 0;
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            ++n;
        }
        return n;
    }

    @Nonnegative
    default public int findFirstIndex(@Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        int n = 0;
        for (Object t : this) {
            if (predicate.test(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Nonnegative
    default public int findLastIndex(@Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        int n = -1;
        int n2 = 0;
        for (Object t : this) {
            if (predicate.test(t)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }
}

