/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.MapEntry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.function.Predicate;

public interface ICommonsOrderedMap<KEYTYPE, VALUETYPE>
extends ICommonsMap<KEYTYPE, VALUETYPE> {
    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public <K, V> ICommonsOrderedMap<K, V> createInstance() {
        return new CommonsLinkedHashMap();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<KEYTYPE> copyOfKeySet() {
        return new CommonsLinkedHashSet(this.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<KEYTYPE> copyOfKeySet(@Nullable Predicate<? super KEYTYPE> predicate) {
        if (predicate == null) {
            return this.copyOfKeySet();
        }
        return CommonsLinkedHashSet.createFiltered(this.keySet(), predicate);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsOrderedSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        CommonsLinkedHashSet<int> commonsLinkedHashSet = new CommonsLinkedHashSet<int>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            commonsLinkedHashSet.add(new MapEntry(entry));
        }
        return commonsLinkedHashSet;
    }

    @Nullable
    default public KEYTYPE getLastKey() {
        return this.getLastKey(null);
    }

    @Nullable
    default public KEYTYPE getLastKey(@Nullable KEYTYPE KEYTYPE) {
        return (KEYTYPE)(this.isEmpty() ? KEYTYPE : CollectionFind.getLastElement(this.keySet()));
    }

    @Nullable
    default public VALUETYPE getLastValue() {
        return this.getLastValue(null);
    }

    @Nullable
    default public VALUETYPE getLastValue(@Nullable VALUETYPE VALUETYPE) {
        KEYTYPE KEYTYPE = this.getLastKey();
        return (VALUETYPE)(KEYTYPE == null ? VALUETYPE : this.get(KEYTYPE));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<KEYTYPE, VALUETYPE> getClone();
}

