/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.wrapped;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class WrappedList<ELEMENTTYPE>
implements ICommonsList<ELEMENTTYPE> {
    @CodingStyleguideUnaware
    private final List<ELEMENTTYPE> m_aSrc;

    public WrappedList(@Nonnull List<ELEMENTTYPE> list) {
        this.m_aSrc = (List)ValueEnforcer.notNull(list, (String)"List");
    }

    @Nonnull
    @ReturnsMutableCopy
    public WrappedList<ELEMENTTYPE> getClone() {
        return new WrappedList<ELEMENTTYPE>(this.m_aSrc);
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    protected List<ELEMENTTYPE> directGetSource() {
        return this.m_aSrc;
    }

    @Nullable
    public ELEMENTTYPE get(@Nonnegative int n) {
        return this.m_aSrc.get(n);
    }

    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.m_aSrc.add(ELEMENTTYPE);
    }

    public void add(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.m_aSrc.add(n, ELEMENTTYPE);
    }

    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> collection) {
        return this.m_aSrc.addAll(collection);
    }

    public boolean addAll(@Nonnegative int n, @Nonnull Collection<? extends ELEMENTTYPE> collection) {
        return this.m_aSrc.addAll(n, collection);
    }

    public void clear() {
        this.m_aSrc.clear();
    }

    public boolean contains(Object object) {
        return this.m_aSrc.contains(object);
    }

    public boolean containsAll(Collection<?> collection) {
        return this.m_aSrc.containsAll(collection);
    }

    public int indexOf(Object object) {
        return this.m_aSrc.indexOf(object);
    }

    public boolean isEmpty() {
        return this.m_aSrc.isEmpty();
    }

    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_aSrc.iterator();
    }

    public int lastIndexOf(Object object) {
        return this.m_aSrc.lastIndexOf(object);
    }

    public ListIterator<ELEMENTTYPE> listIterator() {
        return this.m_aSrc.listIterator();
    }

    public ListIterator<ELEMENTTYPE> listIterator(int n) {
        return this.m_aSrc.listIterator(n);
    }

    public boolean remove(Object object) {
        return this.m_aSrc.remove(object);
    }

    public ELEMENTTYPE remove(int n) {
        return this.m_aSrc.remove(n);
    }

    public boolean removeAll(Collection<?> collection) {
        return this.m_aSrc.removeAll(collection);
    }

    public boolean retainAll(Collection<?> collection) {
        return this.m_aSrc.retainAll(collection);
    }

    public ELEMENTTYPE set(@Nonnegative int n, ELEMENTTYPE ELEMENTTYPE) {
        return this.m_aSrc.set(n, ELEMENTTYPE);
    }

    @Nonnegative
    public int size() {
        return this.m_aSrc.size();
    }

    @ReturnsMutableObject(value="as defined by List")
    public List<ELEMENTTYPE> subList(int n, int n2) {
        return this.m_aSrc.subList(n, n2);
    }

    public Object[] toArray() {
        return this.m_aSrc.toArray();
    }

    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray) {
        return this.m_aSrc.toArray(ARRAYELEMENTTYPEArray);
    }

    public boolean equals(Object object) {
        return this.m_aSrc.equals(object);
    }

    public int hashCode() {
        return this.m_aSrc.hashCode();
    }

    public String toString() {
        return this.m_aSrc.toString();
    }
}

