/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.collection.map.MapHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.IHasSize;
import java.util.Arrays;
import java.util.function.IntFunction;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IntObjectMap<T>
implements IHasSize {
    private static final int FREE_KEY = 0;
    public static final Object NO_VALUE = new Object();
    private final T m_aNoValue = GenericReflection.uncheckedCast((Object)NO_VALUE);
    private int[] m_aKeys;
    private T[] m_aValues;
    private boolean m_bHasFreeKey;
    private T m_aFreeValue = this.m_aNoValue;
    private final float m_fFillFactor;
    private int m_nThreshold;
    private int m_nSize;
    private int m_nMask;

    public IntObjectMap() {
        this(16);
    }

    public IntObjectMap(int n) {
        this(n, 0.75f);
    }

    public IntObjectMap(int n, float f) {
        ValueEnforcer.isBetweenInclusive((float)f, (String)"FillFactor", (float)0.0f, (float)1.0f);
        ValueEnforcer.isGT0((int)n, (String)"Size");
        int n2 = MapHelper.arraySize(n, f);
        this.m_nMask = n2 - 1;
        this.m_fFillFactor = f;
        this.m_aKeys = new int[n2];
        this.m_aValues = IntObjectMap._createValueArray(n2);
        this.m_nThreshold = (int)((float)n2 * f);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static <T> T[] _createValueArray(@Nonnegative int n) {
        Object[] objectArray = new Object[n];
        Arrays.fill(objectArray, NO_VALUE);
        return (Object[])GenericReflection.uncheckedCast((Object)objectArray);
    }

    @Nullable
    public T get(int n) {
        return this.get(n, null);
    }

    @Nullable
    public T get(int n, T t) {
        if (n == 0) {
            return this.m_bHasFreeKey ? this.m_aFreeValue : t;
        }
        int n2 = this._getReadIndex(n);
        return n2 != -1 ? this.m_aValues[n2] : t;
    }

    @Nullable
    public T computeIfAbsent(int n, @Nonnull IntFunction<? extends T> intFunction) {
        T t = this.get(n);
        if (t == null && (t = intFunction.apply(n)) != null) {
            this.put(n, t);
        }
        return t;
    }

    @Nullable
    private T _getOld(T t) {
        return EqualsHelper.identityEqual(t, this.m_aNoValue) ? null : (T)t;
    }

    @Nullable
    public T put(int n, T t) {
        if (n == 0) {
            T t2 = this.m_aFreeValue;
            if (!this.m_bHasFreeKey) {
                ++this.m_nSize;
                this.m_bHasFreeKey = true;
            }
            this.m_aFreeValue = t;
            return this._getOld(t2);
        }
        int n2 = this._getPutIndex(n);
        if (n2 < 0) {
            this._rehash(this.m_aKeys.length * 2);
            n2 = this._getPutIndex(n);
        }
        T t3 = this.m_aValues[n2];
        if (this.m_aKeys[n2] != n) {
            this.m_aKeys[n2] = n;
            this.m_aValues[n2] = t;
            ++this.m_nSize;
            if (this.m_nSize >= this.m_nThreshold) {
                this._rehash(this.m_aKeys.length * 2);
            }
        } else {
            if (this.m_aKeys[n2] != n) {
                throw new IllegalStateException();
            }
            this.m_aValues[n2] = t;
        }
        return this._getOld(t3);
    }

    @Nullable
    public T remove(int n) {
        if (n == 0) {
            if (!this.m_bHasFreeKey) {
                return null;
            }
            this.m_bHasFreeKey = false;
            T t = this.m_aFreeValue;
            this.m_aFreeValue = this.m_aNoValue;
            --this.m_nSize;
            return this._getOld(t);
        }
        int n2 = this._getReadIndex(n);
        if (n2 == -1) {
            return null;
        }
        T t = this.m_aValues[n2];
        this.m_aValues[n2] = this.m_aNoValue;
        this._shiftKeys(n2);
        --this.m_nSize;
        return this._getOld(t);
    }

    @Nonnegative
    public int size() {
        return this.m_nSize;
    }

    public boolean isEmpty() {
        return this.m_nSize == 0;
    }

    private void _rehash(int n) {
        this.m_nThreshold = (int)((float)n * this.m_fFillFactor);
        this.m_nMask = n - 1;
        int n2 = this.m_aKeys.length;
        int[] nArray = this.m_aKeys;
        T[] TArray = this.m_aValues;
        this.m_aKeys = new int[n];
        this.m_aValues = IntObjectMap._createValueArray(n);
        this.m_nSize = this.m_bHasFreeKey ? 1 : 0;
        int n3 = n2;
        while (n3 > 0) {
            if (nArray[--n3] == 0) continue;
            this.put(nArray[n3], TArray[n3]);
        }
    }

    private int _getNextIndex(int n) {
        return n + 1 & this.m_nMask;
    }

    private int _shiftKeys(int n) {
        int n2 = n;
        int[] nArray = this.m_aKeys;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = this._getNextIndex(n2);
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    this.m_aValues[n4] = this.m_aNoValue;
                    return n4;
                }
                int n5 = MapHelper.phiMix(n3) & this.m_nMask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = this._getNextIndex(n2);
            }
            nArray[n4] = n3;
            this.m_aValues[n4] = this.m_aValues[n2];
        }
    }

    @CheckForSigned
    private int _getReadIndex(int n) {
        int n2 = MapHelper.phiMix(n) & this.m_nMask;
        if (this.m_aKeys[n2] == n) {
            return n2;
        }
        if (this.m_aKeys[n2] == 0) {
            return -1;
        }
        int n3 = n2;
        while ((n2 = this._getNextIndex(n2)) != n3) {
            if (this.m_aKeys[n2] == 0) {
                return -1;
            }
            if (this.m_aKeys[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    @CheckForSigned
    private int _getPutIndex(int n) {
        int n2 = this._getReadIndex(n);
        if (n2 >= 0) {
            return n2;
        }
        int n3 = MapHelper.phiMix(n) & this.m_nMask;
        if (this.m_aKeys[n3] == 0) {
            return n3;
        }
        int n4 = n3;
        while (this.m_aKeys[n4] != 0) {
            if ((n4 = this._getNextIndex(n4)) != n3) continue;
            return -1;
        }
        return n4;
    }

    public void forEach(@Nonnull IConsumer<T> iConsumer) {
        if (this.m_bHasFreeKey) {
            iConsumer.accept(0, this.m_aFreeValue);
        }
        int n = this.m_aKeys.length;
        for (int i = 0; i < n; ++i) {
            T t;
            int n2 = this.m_aKeys[i];
            if (n2 == 0 || EqualsHelper.identityEqual(t = this.m_aValues[i], this.m_aNoValue)) continue;
            iConsumer.accept(n2, t);
        }
    }

    @FunctionalInterface
    public static interface IConsumer<T> {
        public void accept(int var1, T var2);
    }
}

