/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.system;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.system.EJVMVendor;
import com.helger.base.system.EJavaVersion;
import com.helger.base.system.EOperatingSystem;
import com.helger.base.system.EProcessorArchitecture;
import java.nio.charset.Charset;
import java.util.Locale;
import org.jspecify.annotations.NonNull;

@Immutable
public final class SystemHelper {
    private static final int NUMBER_OF_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final SystemHelper INSTANCE = new SystemHelper();

    private SystemHelper() {
    }

    @Nonnegative
    public static int getNumberOfProcessors() {
        return NUMBER_OF_PROCESSORS;
    }

    public static @NonNull EProcessorArchitecture getProcessorArchitecture() {
        return EProcessorArchitecture.getCurrentArchitecture();
    }

    public static @NonNull EOperatingSystem getOperatingSystem() {
        return EOperatingSystem.getCurrentOS();
    }

    public static @NonNull String getOperatingSystemName() {
        return EOperatingSystem.getCurrentOSName() + " [" + EOperatingSystem.getCurrentOSVersion() + "]";
    }

    public static @NonNull EJavaVersion getJavaVersion() {
        return EJavaVersion.getCurrentVersion();
    }

    public static @NonNull EJVMVendor getJVMVendor() {
        return EJVMVendor.getCurrentVendor();
    }

    public static @NonNull Locale getSystemLocale() {
        return Locale.getDefault();
    }

    public static @NonNull Charset getSystemCharset() {
        return Charset.defaultCharset();
    }

    public static @NonNull String getSystemCharsetName() {
        return SystemHelper.getSystemCharset().name();
    }

    @Nonnegative
    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Nonnegative
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Nonnegative
    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }
}

