/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.state;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.state.ITriState;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ETriState implements IHasID<String>,
ITriState
{
    TRUE("true", Boolean.TRUE),
    FALSE("false", Boolean.FALSE),
    UNDEFINED("undefined", null);

    private final String m_sID;
    private final Boolean m_aBoolean;

    private ETriState(String string2, Boolean bl) {
        this.m_sID = string2;
        this.m_aBoolean = bl;
    }

    @Override
    public @NonNull @Nonempty String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isTrue() {
        return this == TRUE;
    }

    @Override
    public boolean isFalse() {
        return this == FALSE;
    }

    @Override
    public boolean isDefined() {
        return this != UNDEFINED;
    }

    @Override
    public boolean getAsBooleanValue() {
        if (this == UNDEFINED) {
            throw new IllegalStateException("The TriState is undefined!");
        }
        return this.m_aBoolean;
    }

    @Override
    public boolean getAsBooleanValue(boolean bl) {
        return this == UNDEFINED ? bl : this.m_aBoolean;
    }

    @Override
    public @Nullable Boolean getAsBooleanObj() {
        return this.m_aBoolean;
    }

    @Override
    public @Nullable Boolean getAsBooleanObj(@Nullable Boolean bl) {
        return this == UNDEFINED ? bl : this.m_aBoolean;
    }

    public static @NonNull ETriState valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static @NonNull ETriState valueOf(@Nullable Boolean bl) {
        return bl == null ? UNDEFINED : ETriState.valueOf((boolean)bl);
    }

    public static @NonNull ETriState valueOf(@NonNull ITriState iTriState) {
        return ETriState.valueOf(iTriState.getAsBooleanObj(null));
    }

    public static @Nullable ETriState getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(ETriState.class, string);
    }

    public static @NonNull ETriState getFromIDOrUndefined(@Nullable String string) {
        return ETriState.getFromIDOrDefault(string, UNDEFINED);
    }

    public static @Nullable ETriState getFromIDOrDefault(@Nullable String string, @Nullable ETriState eTriState) {
        return EnumHelper.getFromIDOrDefault(ETriState.class, string, eTriState);
    }
}

