/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.ICharArrayDecoder;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import java.io.Writer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface ICharArrayStreamDecoder
extends ICharArrayDecoder {
    default public void decode(char @Nullable [] cArray, @WillNotClose @NonNull Writer writer) {
        if (cArray == null) {
            this.decode(null, 0, 0, writer);
        } else {
            this.decode(cArray, 0, cArray.length, writer);
        }
    }

    public void decode(char @Nullable [] var1, @Nonnegative int var2, @Nonnegative int var3, @WillNotClose @NonNull Writer var4);

    @Override
    @ReturnsMutableCopy
    default public char @Nullable [] getDecoded(char @Nullable [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumDecodedLength(n2));){
            this.decode(cArray, n, n2, nonBlockingStringWriter);
            char[] cArray2 = nonBlockingStringWriter.getAsCharArray();
            return cArray2;
        }
    }

    default public @Nullable String getDecodedAsString(char @Nullable [] cArray) {
        if (cArray == null) {
            return null;
        }
        return this.getDecodedAsString(cArray, 0, cArray.length);
    }

    default public @Nullable String getDecodedAsString(char @Nullable [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        if (cArray == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(this.getMaximumDecodedLength(n2));){
            this.decode(cArray, n, n2, nonBlockingStringWriter);
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
    }

    default public @Nullable String getDecodedAsString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        return this.getDecodedAsString(cArray, 0, cArray.length);
    }
}

