/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.thirdparty;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.thirdparty.ILicense;
import com.helger.base.thirdparty.IThirdPartyModule;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.version.Version;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class ThirdPartyModule
implements IThirdPartyModule {
    public static final boolean DEFAULT_OPTIONAL = false;
    private final String m_sDisplayName;
    private final String m_sCopyrightOwner;
    private final ILicense m_aLicense;
    private final Version m_aVersion;
    private final String m_sWebSiteURL;
    private final boolean m_bOptional;

    public ThirdPartyModule(@NonNull IThirdPartyModule iThirdPartyModule, boolean bl) {
        this(iThirdPartyModule.getDisplayName(), iThirdPartyModule.getCopyrightOwner(), iThirdPartyModule.getLicense(), iThirdPartyModule.getVersion(), iThirdPartyModule.getWebSiteURL(), bl);
    }

    public ThirdPartyModule(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @NonNull ILicense iLicense) {
        this(string, string2, iLicense, false);
    }

    public ThirdPartyModule(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @NonNull ILicense iLicense, boolean bl) {
        this(string, string2, iLicense, null, null, bl);
    }

    public ThirdPartyModule(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @NonNull ILicense iLicense, @Nullable Version version, @Nullable String string3) {
        this(string, string2, iLicense, version, string3, false);
    }

    public ThirdPartyModule(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @NonNull ILicense iLicense, @Nullable Version version, @Nullable String string3, boolean bl) {
        this.m_sDisplayName = ValueEnforcer.notEmpty(string, "DisplayName");
        this.m_sCopyrightOwner = ValueEnforcer.notEmpty(string2, "CopyrightOwner");
        this.m_aLicense = ValueEnforcer.notNull(iLicense, "License");
        this.m_aVersion = version;
        this.m_sWebSiteURL = string3;
        this.m_bOptional = bl;
    }

    @Override
    @Nonempty
    public @NonNull String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    @Nonempty
    public @NonNull String getCopyrightOwner() {
        return this.m_sCopyrightOwner;
    }

    @Override
    public @NonNull ILicense getLicense() {
        return this.m_aLicense;
    }

    @Override
    public @Nullable Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    public @Nullable String getWebSiteURL() {
        return this.m_sWebSiteURL;
    }

    @Override
    public boolean isOptional() {
        return this.m_bOptional;
    }

    @Override
    public @NonNull ThirdPartyModule getAsOptionalCopy() {
        if (this.m_bOptional) {
            return this;
        }
        return new ThirdPartyModule(this, true);
    }

    @Override
    public @NonNull ThirdPartyModule getAsNonOptionalCopy() {
        if (!this.m_bOptional) {
            return this;
        }
        return new ThirdPartyModule(this, false);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ThirdPartyModule thirdPartyModule = (ThirdPartyModule)object;
        return this.m_sDisplayName.equals(thirdPartyModule.m_sDisplayName) && this.m_sCopyrightOwner.equals(thirdPartyModule.m_sCopyrightOwner) && this.m_aLicense.equals(thirdPartyModule.m_aLicense) && EqualsHelper.equals(this.m_aVersion, thirdPartyModule.m_aVersion) && EqualsHelper.equals(this.m_sWebSiteURL, thirdPartyModule.m_sWebSiteURL) && this.m_bOptional == thirdPartyModule.m_bOptional;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sDisplayName).append(this.m_sCopyrightOwner).append(this.m_aLicense).append(this.m_aVersion).append(this.m_sWebSiteURL).append(this.m_bOptional).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("displayName", this.m_sDisplayName).append("copyrightOwner", this.m_sCopyrightOwner).append("license", this.m_aLicense).appendIfNotNull("version", this.m_aVersion).appendIfNotNull("website", this.m_sWebSiteURL).append("optional", this.m_bOptional).getToString();
    }
}

