/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.thirdparty;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.thirdparty.ILicense;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.version.Version;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class CustomLicense
implements ILicense {
    private final String m_sID;
    private final String m_sName;
    private final Version m_aVersion;
    private final String m_sWebSiteURL;

    public CustomLicense(@Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nullable Version version, @Nullable String string3) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_sName = ValueEnforcer.notEmpty(string2, "Name");
        this.m_aVersion = version;
        this.m_sWebSiteURL = string3;
    }

    @Override
    @Nonempty
    public @NonNull String getID() {
        return this.m_sID;
    }

    @Override
    @Nonempty
    public @NonNull String getDisplayName() {
        return this.m_sName;
    }

    @Override
    public @Nullable Version getVersion() {
        return this.m_aVersion;
    }

    @Override
    public @Nullable String getURL() {
        return this.m_sWebSiteURL;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CustomLicense customLicense = (CustomLicense)object;
        return this.m_sID.equals(customLicense.m_sID) && this.m_sName.equals(customLicense.m_sName) && EqualsHelper.equals(this.m_aVersion, customLicense.m_aVersion) && EqualsHelper.equals(this.m_sWebSiteURL, customLicense.m_sWebSiteURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_sName).append(this.m_aVersion).append(this.m_sWebSiteURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("Name", this.m_sName).appendIfNotNull("Version", this.m_aVersion).appendIfNotNull("Website", this.m_sWebSiteURL).getToString();
    }
}

