/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.AbstractMutableInteger;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class MutableShort
extends AbstractMutableInteger<MutableShort> {
    private short m_nValue;

    public MutableShort(int n) {
        this((short)n);
    }

    public MutableShort(@NonNull Number number) {
        this(number.shortValue());
    }

    public MutableShort(short s) {
        this.m_nValue = s;
    }

    @Override
    public short shortValue() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return this.m_nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_nValue = (short)(this.m_nValue + n);
        this.onAfterChange();
        return this.m_nValue;
    }

    public int inc(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.shortValue());
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    public int dec(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.shortValue());
    }

    public @NonNull EChange set(int n) {
        return this.set((short)n);
    }

    public @NonNull EChange set(short s) {
        if (this.m_nValue == s) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = s;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    public @NonNull EChange set(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.shortValue());
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0;
    }

    @Override
    public boolean isLT0() {
        return this.m_nValue < 0;
    }

    @Override
    public boolean isLE0() {
        return this.m_nValue <= 0;
    }

    @Override
    public boolean isGT0() {
        return this.m_nValue > 0;
    }

    @Override
    public boolean isGE0() {
        return this.m_nValue >= 0;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2 == 0;
    }

    public short getAndInc() {
        short s = this.shortValue();
        this.inc();
        return s;
    }

    public short incAndGet() {
        this.inc();
        return this.shortValue();
    }

    @Override
    public int compareTo(@NonNull MutableShort mutableShort) {
        return CompareHelper.compare(this.m_nValue, mutableShort.m_nValue);
    }

    @Override
    public @NonNull MutableShort getClone() {
        return new MutableShort(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableShort mutableShort = (MutableShort)object;
        return this.m_nValue == mutableShort.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).getToString();
    }
}

