/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.AbstractMutableInteger;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class MutableByte
extends AbstractMutableInteger<MutableByte> {
    private byte m_nValue;

    public MutableByte(int n) {
        this((byte)n);
    }

    public MutableByte(@NonNull Number number) {
        this(number.byteValue());
    }

    public MutableByte(byte by) {
        this.m_nValue = by;
    }

    @Override
    public byte byteValue() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return this.m_nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int n) {
        this.m_nValue = (byte)(this.m_nValue + n);
        this.onAfterChange();
        return this.m_nValue;
    }

    public int inc(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(number.byteValue());
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int n) {
        return this.inc(-n);
    }

    public int dec(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Delta");
        return this.inc(-number.byteValue());
    }

    public @NonNull EChange set(int n) {
        return this.set((byte)n);
    }

    public @NonNull EChange set(byte by) {
        if (this.m_nValue == by) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = by;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    public @NonNull EChange set(@NonNull Number number) {
        ValueEnforcer.notNull(number, "Value");
        return this.set(number.byteValue());
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0;
    }

    @Override
    public boolean isLT0() {
        return this.m_nValue < 0;
    }

    @Override
    public boolean isLE0() {
        return this.m_nValue <= 0;
    }

    @Override
    public boolean isGT0() {
        return this.m_nValue > 0;
    }

    @Override
    public boolean isGE0() {
        return this.m_nValue >= 0;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2 == 0;
    }

    public byte getAndInc() {
        byte by = this.byteValue();
        this.inc();
        return by;
    }

    public byte incAndGet() {
        this.inc();
        return this.byteValue();
    }

    @Override
    public int compareTo(@NonNull MutableByte mutableByte) {
        return CompareHelper.compare(this.m_nValue, mutableByte.m_nValue);
    }

    @Override
    public @NonNull MutableByte getClone() {
        return new MutableByte(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableByte mutableByte = (MutableByte)object;
        return this.m_nValue == mutableByte.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).getToString();
    }
}

