/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric.mutable;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.compare.CompareHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.mutable.IMutableObject;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class MutableBoolean
implements IMutableObject<MutableBoolean> {
    private boolean m_bValue;

    public MutableBoolean(boolean bl) {
        this.m_bValue = bl;
    }

    public MutableBoolean(@NonNull Boolean bl) {
        this((boolean)bl);
    }

    public MutableBoolean(@NonNull MutableBoolean mutableBoolean) {
        this(mutableBoolean.m_bValue);
    }

    @OverrideOnDemand
    protected void onAfterChange() {
    }

    public boolean booleanValue() {
        return this.m_bValue;
    }

    public @NonNull Boolean getAsBoolean() {
        return this.m_bValue;
    }

    public @NonNull EChange set(@NonNull Boolean bl) {
        ValueEnforcer.notNull(bl, "Value");
        return this.set((boolean)bl);
    }

    public @NonNull EChange set(@NonNull MutableBoolean mutableBoolean) {
        ValueEnforcer.notNull(mutableBoolean, "Value");
        return this.set(mutableBoolean.m_bValue);
    }

    public @NonNull EChange set(boolean bl) {
        if (this.m_bValue == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bValue = bl;
        this.onAfterChange();
        return EChange.CHANGED;
    }

    public <T> @Nullable T getIf(@NonNull Supplier<? extends T> supplier) {
        return this.getIf(supplier, null);
    }

    public <T> @Nullable T getIf(@NonNull Supplier<? extends T> supplier, @Nullable T t) {
        if (this.m_bValue) {
            return supplier.get();
        }
        return t;
    }

    @Override
    public int compareTo(@NonNull MutableBoolean mutableBoolean) {
        return CompareHelper.compareFalseBeforeTrue(this.m_bValue, mutableBoolean.m_bValue);
    }

    @Override
    public @NonNull MutableBoolean getClone() {
        return new MutableBoolean(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableBoolean mutableBoolean = (MutableBoolean)object;
        return this.m_bValue == mutableBoolean.m_bValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_bValue).getToString();
    }
}

