/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.io.stream.WrappedReader;
import com.helger.base.tostring.ToStringGenerator;
import java.io.IOException;
import java.io.Reader;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingReader
extends WrappedReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingReader.class);
    private long m_nPosition = 0L;

    public LoggingReader(@NonNull Reader reader) {
        super(reader);
    }

    public final long getPosition() {
        return this.m_nPosition;
    }

    @OverrideOnDemand
    protected void onRead(int n, long l) {
        LOGGER.info("Read " + n + " char(s); now at " + l);
    }

    @OverrideOnDemand
    protected void onSkip(long l, long l2) {
        LOGGER.info("Skipped " + l + " char(s); now at " + l2);
    }

    @OverrideOnDemand
    protected void onMark(int n, long l) {
        LOGGER.info("Marked at " + l + " with read-limit of " + n);
    }

    @OverrideOnDemand
    protected void onReset(long l) {
        LOGGER.info("Reset at " + l);
    }

    @OverrideOnDemand
    protected void onClose(long l) {
        LOGGER.info("Close at " + l);
    }

    @Override
    public final int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.m_nPosition;
            this.onRead(1, this.m_nPosition);
        }
        return n;
    }

    @Override
    public final int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 != -1) {
            this.m_nPosition += (long)n3;
            this.onRead(n3, this.m_nPosition);
        }
        return n3;
    }

    @Override
    public final long skip(@Nonnegative long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            this.m_nPosition += l2;
            this.onSkip(l2, this.m_nPosition);
        }
        return l2;
    }

    @Override
    public final void mark(@Nonnegative int n) throws IOException {
        super.mark(n);
        this.onMark(n, this.m_nPosition);
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.onReset(this.m_nPosition);
    }

    @Override
    public final void close() throws IOException {
        super.close();
        this.onClose(this.m_nPosition);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("position", this.m_nPosition).getToString();
    }
}

