/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.id.factory;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.id.factory.IIntIDFactory;
import com.helger.base.id.factory.ILongIDFactory;
import com.helger.base.id.factory.IStringIDFactory;
import com.helger.base.id.factory.MemoryIntIDFactory;
import com.helger.base.id.factory.MemoryLongIDFactory;
import com.helger.base.id.factory.StringIDFromGlobalIntIDFactory;
import com.helger.base.id.factory.StringIDFromGlobalPersistentIntIDFactory;
import com.helger.base.state.EChange;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GlobalIDFactory {
    public static final String DEFAULT_PREFIX = "id";
    public static final int STRING_ID_MAX_LENGTH = 40;
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalIDFactory.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static IIntIDFactory s_aIntIDFactory = new MemoryIntIDFactory();
    private static IIntIDFactory s_aPersistentIntIDFactory;
    private static ILongIDFactory s_aLongIDFactory;
    private static ILongIDFactory s_aPersistentLongIDFactory;
    private static IStringIDFactory s_aStringIDFactory;
    private static IStringIDFactory s_aPersistentStringIDFactory;
    private static final GlobalIDFactory INSTANCE;

    private GlobalIDFactory() {
    }

    public static boolean hasIntIDFactory() {
        return GlobalIDFactory.getIntIDFactory() != null;
    }

    public static @Nullable IIntIDFactory getIntIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aIntIDFactory);
    }

    public static @NonNull EChange setIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            IIntIDFactory iIntIDFactory2 = s_aIntIDFactory;
            if (EqualsHelper.equals(iIntIDFactory2, iIntIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting in-memory int ID factory " + String.valueOf(iIntIDFactory));
            }
            s_aIntIDFactory = iIntIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentIntIDFactory() {
        return GlobalIDFactory.getPersistentIntIDFactory() != null;
    }

    public static @Nullable IIntIDFactory getPersistentIntIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aPersistentIntIDFactory);
    }

    public static @NonNull EChange setPersistentIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            IIntIDFactory iIntIDFactory2 = s_aPersistentIntIDFactory;
            if (EqualsHelper.equals(iIntIDFactory2, iIntIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting persistent int ID factory " + String.valueOf(iIntIDFactory));
            }
            s_aPersistentIntIDFactory = iIntIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasLongIDFactory() {
        return GlobalIDFactory.getLongIDFactory() != null;
    }

    public static @Nullable ILongIDFactory getLongIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aLongIDFactory);
    }

    public static @NonNull EChange setLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            ILongIDFactory iLongIDFactory2 = s_aLongIDFactory;
            if (EqualsHelper.equals(iLongIDFactory2, iLongIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting in-memory long ID factory " + String.valueOf(iLongIDFactory));
            }
            s_aLongIDFactory = iLongIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentLongIDFactory() {
        return GlobalIDFactory.getPersistentLongIDFactory() != null;
    }

    public static @Nullable ILongIDFactory getPersistentLongIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aPersistentLongIDFactory);
    }

    public static @NonNull EChange setPersistentLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            ILongIDFactory iLongIDFactory2 = s_aPersistentLongIDFactory;
            if (EqualsHelper.equals(iLongIDFactory2, iLongIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting persistent long ID factory " + String.valueOf(iLongIDFactory));
            }
            s_aPersistentLongIDFactory = iLongIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasStringIDFactory() {
        return GlobalIDFactory.getStringIDFactory() != null;
    }

    public static @Nullable IStringIDFactory getStringIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aStringIDFactory);
    }

    public static @NonNull EChange setStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            IStringIDFactory iStringIDFactory2 = s_aStringIDFactory;
            if (EqualsHelper.equals(iStringIDFactory2, iStringIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting in-memory string ID factory " + String.valueOf(iStringIDFactory));
            }
            s_aStringIDFactory = iStringIDFactory;
            return EChange.CHANGED;
        });
    }

    public static boolean hasPersistentStringIDFactory() {
        return GlobalIDFactory.getPersistentStringIDFactory() != null;
    }

    public static @Nullable IStringIDFactory getPersistentStringIDFactory() {
        return RW_LOCK.readLockedGet(() -> s_aPersistentStringIDFactory);
    }

    public static @NonNull EChange setPersistentStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        return RW_LOCK.writeLockedGet(() -> {
            IStringIDFactory iStringIDFactory2 = s_aPersistentStringIDFactory;
            if (EqualsHelper.equals(iStringIDFactory2, iStringIDFactory)) {
                return EChange.UNCHANGED;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Setting persistent string ID factory " + String.valueOf(iStringIDFactory));
            }
            s_aPersistentStringIDFactory = iStringIDFactory;
            return EChange.CHANGED;
        });
    }

    public static int getNewIntID() {
        return RW_LOCK.readLockedInt(() -> {
            IIntIDFactory iIntIDFactory = s_aIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            return iIntIDFactory.getNewID();
        });
    }

    public static int getNewPersistentIntID() {
        return RW_LOCK.readLockedInt(() -> {
            IIntIDFactory iIntIDFactory = s_aPersistentIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            return iIntIDFactory.getNewID();
        });
    }

    public static long getNewLongID() {
        return RW_LOCK.readLockedLong(() -> {
            ILongIDFactory iLongIDFactory = s_aLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            return iLongIDFactory.getNewID();
        });
    }

    public static long getNewPersistentLongID() {
        return RW_LOCK.readLockedLong(() -> {
            ILongIDFactory iLongIDFactory = s_aPersistentLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            return iLongIDFactory.getNewID();
        });
    }

    public static @NonNull String getNewStringID() {
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            String string = (String)iStringIDFactory.getNewID();
            if (string.length() > 40) {
                throw new IllegalStateException("The created String ID has a length of " + string.length() + " which exceeds the maximum allowed length of 40");
            }
            return string;
        });
    }

    public static @NonNull String getNewPersistentStringID() {
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aPersistentStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            String string = (String)iStringIDFactory.getNewID();
            if (string.length() > 40) {
                throw new IllegalStateException("The created String ID has a length of " + string.length() + " which exceeds the maximum allowed length of 40");
            }
            return string;
        });
    }

    public static int[] getBulkNewIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IIntIDFactory iIntIDFactory = s_aIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = iIntIDFactory.getNewID();
            }
            return nArray;
        });
    }

    public static int[] getBulkNewPersistentIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IIntIDFactory iIntIDFactory = s_aPersistentIntIDFactory;
            if (iIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = iIntIDFactory.getNewID();
            }
            return nArray;
        });
    }

    public static long[] getBulkNewLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            ILongIDFactory iLongIDFactory = s_aLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = iLongIDFactory.getNewID();
            }
            return lArray;
        });
    }

    public static long[] getBulkNewPersistentLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            ILongIDFactory iLongIDFactory = s_aPersistentLongIDFactory;
            if (iLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = iLongIDFactory.getNewID();
            }
            return lArray;
        });
    }

    public static @NonNull String[] getBulkNewStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)iStringIDFactory.getNewID();
                if (stringArray[i].length() <= 40) continue;
                throw new IllegalStateException("The created String ID has a length of " + stringArray[i].length() + " which exceeds the maximum allowed length of 40");
            }
            return stringArray;
        });
    }

    public static @NonNull String[] getBulkNewPersistentStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        return RW_LOCK.readLockedGet(() -> {
            IStringIDFactory iStringIDFactory = s_aPersistentStringIDFactory;
            if (iStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)iStringIDFactory.getNewID();
                if (stringArray[i].length() <= 40) continue;
                throw new IllegalStateException("The created String ID has a length of " + stringArray[i].length() + " which exceeds the maximum allowed length of 40");
            }
            return stringArray;
        });
    }

    static {
        s_aLongIDFactory = new MemoryLongIDFactory();
        s_aStringIDFactory = new StringIDFromGlobalIntIDFactory();
        s_aPersistentStringIDFactory = new StringIDFromGlobalPersistentIntIDFactory();
        INSTANCE = new GlobalIDFactory();
    }
}

