/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.clone;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.clone.ICloneable;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.base.reflection.GenericReflection;
import java.lang.reflect.Constructor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CloneHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloneHelper.class);
    private static final CloneHelper INSTANCE = new CloneHelper();

    private CloneHelper() {
    }

    private static <DATATYPE> @Nullable DATATYPE _getGenericClone(@NonNull DATATYPE DATATYPE) {
        if (DATATYPE instanceof ICloneable) {
            return ((ICloneable)GenericReflection.uncheckedCast(DATATYPE)).getClone();
        }
        try {
            return (DATATYPE)GenericReflection.invokeMethod(DATATYPE, "clone", new Object[0]);
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to invoke clone on " + DATATYPE.getClass().getName());
            try {
                Constructor<DATATYPE> constructor = GenericReflection.findConstructor(DATATYPE, DATATYPE.getClass());
                if (constructor != null) {
                    return constructor.newInstance(DATATYPE);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor or the methods are invisible.");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a clone method nor a (visible) copy constructor or the methods are invisible.");
            }
            catch (Exception exception2) {
                LOGGER.error("Failed to clone object of type '" + DATATYPE.getClass().getName() + "' because it has neither a (visible) clone method nor a copy constructor.", (Throwable)exception2);
            }
            return null;
        }
    }

    public static <DATATYPE> @Nullable DATATYPE getClonedValue(@Nullable DATATYPE DATATYPE) {
        if (DATATYPE == null) {
            return null;
        }
        Class<?> clazz = DATATYPE.getClass();
        if (ClassHelper.isPrimitiveWrapperType(clazz) || DATATYPE instanceof String || clazz.getAnnotation(Immutable.class) != null) {
            return DATATYPE;
        }
        return CloneHelper._getGenericClone(DATATYPE);
    }

    public static <DATATYPE extends ICloneable<DATATYPE>> @Nullable DATATYPE getCloneIfNotNull(@Nullable DATATYPE DATATYPE) {
        if (DATATYPE == null) {
            return null;
        }
        return (DATATYPE)((ICloneable)DATATYPE.getClone());
    }
}

