/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.numeric;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.CGlobal;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

@Immutable
public final class BigHelper {
    private static final BigHelper INSTANCE = new BigHelper();

    private BigHelper() {
    }

    @Nonnull
    public static BigDecimal getDividedBigDecimal(long l, long l2) {
        return BigHelper.toBigDecimal(l).divide(BigHelper.toBigDecimal(l2));
    }

    @Nonnull
    public static BigDecimal getDividedBigDecimal(long l, long l2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return BigHelper.toBigDecimal(l).divide(BigHelper.toBigDecimal(l2), n, roundingMode);
    }

    @Nonnull
    public static BigDecimal getMaxBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) <= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMaxBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) <= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    @Nonnull
    public static BigDecimal getMinBigDecimal(@Nonnull BigDecimal bigDecimal, BigDecimal ... bigDecimalArray) {
        BigDecimal bigDecimal2 = bigDecimal;
        for (BigDecimal bigDecimal3 : bigDecimalArray) {
            if (bigDecimal3.compareTo(bigDecimal2) >= 0) continue;
            bigDecimal2 = bigDecimal3;
        }
        return bigDecimal2;
    }

    @Nonnull
    public static BigInteger getMinBigInteger(@Nonnull BigInteger bigInteger, BigInteger ... bigIntegerArray) {
        BigInteger bigInteger2 = bigInteger;
        for (BigInteger bigInteger3 : bigIntegerArray) {
            if (bigInteger3.compareTo(bigInteger2) >= 0) continue;
            bigInteger2 = bigInteger3;
        }
        return bigInteger2;
    }

    @Nonnull
    public static BigDecimal abs(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.abs();
    }

    @Nonnull
    public static BigInteger abs(@Nonnull BigInteger bigInteger) {
        return bigInteger.abs();
    }

    public static boolean equalValues(@Nullable BigDecimal bigDecimal3, @Nullable BigDecimal bigDecimal4) {
        return EqualsHelper.equalsCustom(bigDecimal3, bigDecimal4, (bigDecimal, bigDecimal2) -> bigDecimal.compareTo((BigDecimal)bigDecimal2) == 0);
    }

    public static boolean isEQ0(@Nonnull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isNE0(@Nonnull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, BigDecimal.ZERO);
    }

    public static boolean isLT0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isLE0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static boolean isGT0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean isGE0(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ZERO) >= 0;
    }

    public static boolean isEQ1(@Nonnull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isNE1(@Nonnull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, BigDecimal.ONE);
    }

    public static boolean isLT1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) < 0;
    }

    public static boolean isLE1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) <= 0;
    }

    public static boolean isGT1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) > 0;
    }

    public static boolean isGE1(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) >= 0;
    }

    public static boolean isEQ10(@Nonnull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isNE10(@Nonnull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, BigDecimal.TEN);
    }

    public static boolean isLT10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) < 0;
    }

    public static boolean isLE10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) <= 0;
    }

    public static boolean isGT10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) > 0;
    }

    public static boolean isGE10(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.TEN) >= 0;
    }

    public static boolean isEQ100(@Nonnull BigDecimal bigDecimal) {
        return BigHelper.equalValues(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isNE100(@Nonnull BigDecimal bigDecimal) {
        return !BigHelper.equalValues(bigDecimal, CGlobal.BIGDEC_100);
    }

    public static boolean isLT100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) < 0;
    }

    public static boolean isLE100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) <= 0;
    }

    public static boolean isGT100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) > 0;
    }

    public static boolean isGE100(@Nonnull BigDecimal bigDecimal) {
        return bigDecimal.compareTo(CGlobal.BIGDEC_100) >= 0;
    }

    public static boolean isEQ0(@Nonnull BigInteger bigInteger) {
        return bigInteger.equals(BigInteger.ZERO);
    }

    public static boolean isNE0(@Nonnull BigInteger bigInteger) {
        return !bigInteger.equals(BigInteger.ZERO);
    }

    public static boolean isLT0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) < 0;
    }

    public static boolean isLE0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) <= 0;
    }

    public static boolean isGT0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) > 0;
    }

    public static boolean isGE0(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) >= 0;
    }

    public static boolean isEQ1(@Nonnull BigInteger bigInteger) {
        return bigInteger.equals(BigInteger.ONE);
    }

    public static boolean isNE1(@Nonnull BigInteger bigInteger) {
        return !bigInteger.equals(BigInteger.ONE);
    }

    public static boolean isLT1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) < 0;
    }

    public static boolean isLE1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) <= 0;
    }

    public static boolean isGT1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) > 0;
    }

    public static boolean isGE1(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE) >= 0;
    }

    public static boolean isEQ10(@Nonnull BigInteger bigInteger) {
        return bigInteger.equals(BigInteger.TEN);
    }

    public static boolean isNE10(@Nonnull BigInteger bigInteger) {
        return !bigInteger.equals(BigInteger.TEN);
    }

    public static boolean isLT10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) < 0;
    }

    public static boolean isLE10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) <= 0;
    }

    public static boolean isGT10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) > 0;
    }

    public static boolean isGE10(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.TEN) >= 0;
    }

    public static boolean isEQ100(@Nonnull BigInteger bigInteger) {
        return bigInteger.equals(CGlobal.BIGINT_100);
    }

    public static boolean isNE100(@Nonnull BigInteger bigInteger) {
        return !bigInteger.equals(CGlobal.BIGINT_100);
    }

    public static boolean isLT100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) < 0;
    }

    public static boolean isLE100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) <= 0;
    }

    public static boolean isGT100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) > 0;
    }

    public static boolean isGE100(@Nonnull BigInteger bigInteger) {
        return bigInteger.compareTo(CGlobal.BIGINT_100) >= 0;
    }

    @Nullable
    @CheckReturnValue
    public static BigDecimal getWithoutTrailingZeroes(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return BigHelper.getWithoutTrailingZeroes(new BigDecimal(string));
    }

    @Nullable
    @CheckReturnValue
    public static BigDecimal getWithoutTrailingZeroes(@Nullable BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        if (BigDecimal.ZERO.compareTo(bigDecimal) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        return bigDecimal2.scale() >= 0 ? bigDecimal2 : bigDecimal2.setScale(0);
    }

    @Nonnegative
    public static int getFractionDigits(@Nonnull BigDecimal bigDecimal) {
        return BigHelper.getWithoutTrailingZeroes(bigDecimal).scale();
    }

    @Nonnull
    public static BigDecimal addPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.add(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal addPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.add(bigDecimal2)).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    @Nonnull
    public static BigDecimal subtractPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.subtract(bigDecimal2)).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal subtractPercent(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return bigDecimal.multiply(CGlobal.BIGDEC_100.subtract(bigDecimal2)).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    @Nonnull
    public static BigDecimal getPercentValue(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100);
    }

    @Nonnull
    public static BigDecimal getPercentValue(@Nonnull BigDecimal bigDecimal, @Nonnull BigDecimal bigDecimal2, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        return bigDecimal.multiply(bigDecimal2).divide(CGlobal.BIGDEC_100, n, roundingMode);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(int n) {
        return BigDecimal.valueOf(n);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(long l) {
        return BigDecimal.valueOf(l);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(float f) {
        return BigDecimal.valueOf(f);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(double d) {
        return BigDecimal.valueOf(d);
    }

    @Nonnull
    public static BigDecimal toBigDecimal(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Number");
        return new BigDecimal(number.toString());
    }

    @Nonnull
    public static BigDecimal toBigDecimal(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Number");
        return new BigDecimal(string);
    }

    @Nonnull
    public static BigInteger toBigInteger(int n) {
        return BigInteger.valueOf(n);
    }

    @Nonnull
    public static BigInteger toBigInteger(long l) {
        return BigInteger.valueOf(l);
    }

    @Nonnull
    public static BigInteger toBigInteger(@Nonnull Number number) {
        ValueEnforcer.notNull(number, "Number");
        return new BigInteger(number.toString(), 10);
    }

    @Nonnull
    public static BigInteger toBigInteger(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Number");
        return new BigInteger(string, 10);
    }
}

