/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.base.concurrent.SimpleLock;
import com.helger.base.io.nonblocking.NonBlockingBitOutputStream;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;

public class BitOutputStream
extends NonBlockingBitOutputStream {
    private final SimpleLock m_aLock = new SimpleLock();

    public BitOutputStream(@Nonnull OutputStream outputStream, @Nonnull ByteOrder byteOrder) {
        super(outputStream, byteOrder);
    }

    @Override
    public void writeBit(int n) throws IOException {
        this.m_aLock.lock();
        try {
            super.writeBit(n);
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.m_aLock.lockedThrowing(() -> super.flush());
    }

    @Override
    public void close() {
        this.m_aLock.locked(() -> super.close());
    }
}

