/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.url;

import com.helger.annotation.Nonempty;
import com.helger.base.io.stream.StreamHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.net.URL;

@FunctionalInterface
public interface IURLDownloader {
    @Nullable
    public byte[] downloadURL(@Nonnull @Nonempty String var1) throws Exception;

    @Nonnull
    public static IURLDownloader createDefault() {
        return string -> {
            try (InputStream inputStream = new URL(string).openStream();){
                byte[] byArray = StreamHelper.getAllBytes(inputStream);
                return byArray;
            }
        };
    }
}

