/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.system;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.system.EJVMVendor;
import com.helger.base.system.EJavaVersion;
import com.helger.base.system.EOperatingSystem;
import com.helger.base.system.EProcessorArchitecture;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.util.Locale;

@Immutable
public final class SystemHelper {
    private static final int NUMBER_OF_PROCESSORS = Runtime.getRuntime().availableProcessors();
    private static final SystemHelper INSTANCE = new SystemHelper();

    private SystemHelper() {
    }

    @Nonnegative
    public static int getNumberOfProcessors() {
        return NUMBER_OF_PROCESSORS;
    }

    @Nonnull
    public static EProcessorArchitecture getProcessorArchitecture() {
        return EProcessorArchitecture.getCurrentArchitecture();
    }

    @Nonnull
    public static EOperatingSystem getOperatingSystem() {
        return EOperatingSystem.getCurrentOS();
    }

    @Nonnull
    public static String getOperatingSystemName() {
        return EOperatingSystem.getCurrentOSName() + " [" + EOperatingSystem.getCurrentOSVersion() + "]";
    }

    @Nonnull
    public static EJavaVersion getJavaVersion() {
        return EJavaVersion.getCurrentVersion();
    }

    @Nonnull
    public static EJVMVendor getJVMVendor() {
        return EJVMVendor.getCurrentVendor();
    }

    @Nonnull
    public static Locale getSystemLocale() {
        return Locale.getDefault();
    }

    @Nonnull
    public static Charset getSystemCharset() {
        return Charset.defaultCharset();
    }

    @Nonnull
    public static String getSystemCharsetName() {
        return SystemHelper.getSystemCharset().name();
    }

    @Nonnegative
    public static long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    @Nonnegative
    public static long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Nonnegative
    public static long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }
}

