/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.iface;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.ArrayHelper;
import com.helger.base.iface.IHasSize;
import com.helger.base.io.iface.IHasInputStreamAndReader;
import com.helger.base.io.iface.IWriteToStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.string.StringHex;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public interface IHasByteArray
extends IHasSize,
IHasInputStreamAndReader,
IWriteToStream {
    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean isNotEmpty() {
        return this.size() > 0;
    }

    public boolean isCopy();

    @Nonnull
    @ReturnsMutableCopy
    default public byte[] getAllBytes() {
        return ArrayHelper.getCopy(this.bytes(), this.getOffset(), this.size());
    }

    @Nonnull
    @ReturnsMutableObject
    public byte[] bytes();

    default public boolean isPartialArray() {
        return this.hasOffset() || this.bytes().length != this.size();
    }

    @Nonnegative
    public int getOffset();

    default public boolean hasOffset() {
        return this.getOffset() > 0;
    }

    @Override
    @Nonnull
    default public InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.bytes(), this.getOffset(), this.size());
    }

    @Override
    default public boolean isReadMultiple() {
        return true;
    }

    @Override
    default public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes(), this.getOffset(), this.size());
    }

    default public boolean startsWith(@Nonnull byte[] byArray) {
        return ArrayHelper.startsWith(this.bytes(), this.getOffset(), this.size(), byArray, 0, byArray.length);
    }

    @Nonnull
    default public String getHexEncoded() {
        return StringHex.getHexEncoded(this.bytes(), this.getOffset(), this.size());
    }

    @Nonnull
    default public String getBytesAsString(@Nonnull Charset charset) {
        return new String(this.bytes(), this.getOffset(), this.size(), charset);
    }
}

