/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.debug;

import com.helger.annotation.concurrent.ThreadSafe;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class GlobalDebug {
    public static final boolean DEFAULT_DEBUG_MODE = false;
    public static final boolean DEFAULT_PRODUCTION_MODE = false;
    public static final boolean DEFAULT_SILENT_MODE = true;
    private static final AtomicBoolean DEBUG_MODE = new AtomicBoolean(false);
    private static final AtomicBoolean PRODUCTION_MODE = new AtomicBoolean(false);

    public void setDebugMode(boolean bl) {
        GlobalDebug.setDebugModeDirect(bl);
    }

    public void setProductionMode(boolean bl) {
        GlobalDebug.setProductionModeDirect(bl);
    }

    public static void setDebugModeDirect(boolean bl) {
        DEBUG_MODE.set(bl);
    }

    public static void setProductionModeDirect(boolean bl) {
        PRODUCTION_MODE.set(bl);
        if (bl) {
            GlobalDebug.setDebugModeDirect(false);
        }
    }

    public static boolean isDebugMode() {
        return DEBUG_MODE.get();
    }

    public static boolean isProductionMode() {
        return PRODUCTION_MODE.get();
    }
}

