/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.concurrent;

import com.helger.base.builder.IResettableBuilder;
import com.helger.base.concurrent.BasicThreadFactory;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.ThreadFactory;

public class BasicThreadFactoryBuilder
implements IResettableBuilder<BasicThreadFactory> {
    ThreadFactory m_aWrappedFactory;
    ThreadGroup m_aThreadGroup;
    Thread.UncaughtExceptionHandler m_aUncaughtExceptionHandler = BasicThreadFactory.s_aDefaultUncaughtExceptionHandler;
    String m_sNamingPattern;
    Integer m_nPriority;
    ETriState m_eDaemon = ETriState.UNDEFINED;

    @Nonnull
    public final BasicThreadFactoryBuilder wrappedFactory(@Nonnull ThreadFactory threadFactory) {
        ValueEnforcer.notNull(threadFactory, "Factory");
        this.m_aWrappedFactory = threadFactory;
        return this;
    }

    @Nonnull
    public final BasicThreadFactoryBuilder threadGroup(@Nullable ThreadGroup threadGroup) {
        this.m_aThreadGroup = threadGroup;
        return this;
    }

    @Nonnull
    public final BasicThreadFactoryBuilder uncaughtExceptionHandler(@Nonnull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        ValueEnforcer.notNull(uncaughtExceptionHandler, "ExceptionHandler");
        this.m_aUncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    @Nonnull
    public final BasicThreadFactoryBuilder namingPattern(@Nonnull String string) {
        ValueEnforcer.notNull(string, "NamingPattern");
        this.m_sNamingPattern = string;
        return this;
    }

    @Nonnull
    public final BasicThreadFactoryBuilder priority(int n) {
        this.m_nPriority = n;
        return this;
    }

    @Nonnull
    public final BasicThreadFactoryBuilder daemon(boolean bl) {
        this.m_eDaemon = ETriState.valueOf(bl);
        return this;
    }

    @Override
    public void reset() {
        this.m_aWrappedFactory = null;
        this.m_aThreadGroup = null;
        this.m_aUncaughtExceptionHandler = null;
        this.m_sNamingPattern = null;
        this.m_nPriority = null;
        this.m_eDaemon = null;
    }

    @Override
    @Nonnull
    public BasicThreadFactory build() {
        return new BasicThreadFactory(this);
    }
}

