/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.concurrent;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.concurrent.BasicThreadFactoryBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicThreadFactory
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicThreadFactory.class);
    static Thread.UncaughtExceptionHandler s_aDefaultUncaughtExceptionHandler = (thread, throwable) -> LOGGER.error("Uncaught exception from Thread " + thread.getName(), throwable);
    private final AtomicLong m_aThreadCounter = new AtomicLong();
    private final ThreadFactory m_aWrappedFactory;
    private final Thread.UncaughtExceptionHandler m_aUncaughtExceptionHandler;
    private final String m_sNamingPattern;
    private final Integer m_aPriority;
    private final ETriState m_eDaemon;

    public static void setDefaultUncaughtExceptionHandler(@Nonnull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        ValueEnforcer.notNull(uncaughtExceptionHandler, "DefaultUncaughtExceptionHandler");
        s_aDefaultUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Nonnull
    public static Thread.UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return s_aDefaultUncaughtExceptionHandler;
    }

    protected BasicThreadFactory(@Nonnull BasicThreadFactoryBuilder basicThreadFactoryBuilder) {
        this.m_aWrappedFactory = basicThreadFactoryBuilder.m_aWrappedFactory == null ? new ExtendedDefaultThreadFactory(basicThreadFactoryBuilder.m_aThreadGroup) : basicThreadFactoryBuilder.m_aWrappedFactory;
        this.m_sNamingPattern = basicThreadFactoryBuilder.m_sNamingPattern;
        this.m_aPriority = basicThreadFactoryBuilder.m_nPriority;
        this.m_eDaemon = basicThreadFactoryBuilder.m_eDaemon;
        this.m_aUncaughtExceptionHandler = basicThreadFactoryBuilder.m_aUncaughtExceptionHandler;
    }

    @Nonnull
    public final ThreadFactory getWrappedFactory() {
        return this.m_aWrappedFactory;
    }

    @Nonnull
    public final String getNamingPattern() {
        return this.m_sNamingPattern;
    }

    @Nonnull
    public final ETriState getDaemon() {
        return this.m_eDaemon;
    }

    @Nullable
    public final Integer getPriority() {
        return this.m_aPriority;
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.m_aUncaughtExceptionHandler;
    }

    public long getThreadCount() {
        return this.m_aThreadCounter.get();
    }

    @OverrideOnDemand
    protected void initializeThread(@Nonnull Thread thread) {
        if (this.m_sNamingPattern != null) {
            Long l = this.m_aThreadCounter.incrementAndGet();
            thread.setName(String.format((Locale)null, this.m_sNamingPattern, l));
        }
        if (this.m_aUncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.m_aUncaughtExceptionHandler);
        }
        if (this.m_aPriority != null) {
            thread.setPriority(this.m_aPriority);
        }
        if (this.m_eDaemon.isDefined()) {
            thread.setDaemon(this.m_eDaemon.getAsBooleanValue());
        }
    }

    @Override
    @Nonnull
    public Thread newThread(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        Thread thread = this.getWrappedFactory().newThread(runnable);
        this.initializeThread(thread);
        return thread;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ThreadCounter", this.m_aThreadCounter).append("WrappedFactory", this.m_aWrappedFactory).append("UncaughtExceptionHandler", this.m_aUncaughtExceptionHandler).append("NamingPattern", this.m_sNamingPattern).append("Priority", this.m_aPriority).append("Daemon", this.m_eDaemon).getToString();
    }

    @Nonnull
    public static BasicThreadFactoryBuilder builder() {
        return new BasicThreadFactoryBuilder();
    }

    static class ExtendedDefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger FACTORY_ID = new AtomicInteger(1);
        private final ThreadGroup m_aGroup;
        private final AtomicInteger m_aThreadNumber = new AtomicInteger(1);
        private final String m_sNamePrefix;

        ExtendedDefaultThreadFactory(@Nullable ThreadGroup threadGroup) {
            this.m_aGroup = threadGroup != null ? threadGroup : Thread.currentThread().getThreadGroup();
            this.m_sNamePrefix = "factory-" + FACTORY_ID.getAndIncrement() + "-thread-";
        }

        @Override
        @Nonnull
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread thread = new Thread(this.m_aGroup, runnable, this.m_sNamePrefix + this.m_aThreadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

