/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.string;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.CGlobal;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

@Immutable
public final class StringReplace {
    private StringReplace() {
    }

    public static String replaceAllSafe(@Nullable String string, @Nonnull String string2, @Nullable CharSequence charSequence) {
        return StringReplace.replaceAll(string, string2, StringHelper.getNotNull(charSequence, (CharSequence)""));
    }

    @Nullable
    public static String replaceAll(@Nullable String string, @Nonnull String string2, @Nonnull CharSequence charSequence) {
        int n;
        int n2;
        ValueEnforcer.notEmpty(string2, "SearchText");
        ValueEnforcer.notNull(charSequence, "ReplacementText");
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        int n3 = string2.length();
        if (n3 == (n2 = charSequence.length())) {
            if (string2.equals(charSequence)) {
                return string;
            }
            if (n3 == 1) {
                return StringReplace.replaceAll(string, string2.charAt(0), charSequence.charAt(0));
            }
        }
        if ((n = string.indexOf(string2, 0)) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 >= n2 ? string.length() : string.length() * 2);
        int n4 = 0;
        do {
            stringBuilder.append(string, n4, n).append(charSequence);
            n4 = n += n3;
        } while ((n = string.indexOf(string2, n)) != -1);
        stringBuilder.append(string, n4, string.length());
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceAll(@Nullable String string, char c, char c2) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        if (c == c2) {
            return string;
        }
        int n = string.indexOf(c, 0);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        do {
            stringBuilder.append(string, n2, n).append(c2);
            n2 = ++n;
        } while ((n = string.indexOf(c, n)) != -1);
        stringBuilder.append(string, n2, string.length());
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceAllRepeatedly(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        String string4;
        ValueEnforcer.notEmpty(string2, "SearchText");
        ValueEnforcer.notNull(string3, "ReplacementText");
        ValueEnforcer.isFalse(string3.contains(string2), "Loop detection: replacementText must not contain searchText");
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        String string5 = string;
        while (!(string4 = string5).equals(string5 = StringReplace.replaceAll(string5, string2, string3))) {
        }
        return string5;
    }

    public static int getReplaceMultipleResultLength(@Nonnull char[] cArray, @Nonnull @Nonempty char[] cArray2, @Nonnull @Nonempty char[][] cArray3) {
        int n = 0;
        boolean bl = false;
        for (char c : cArray) {
            int n2 = 1;
            for (int i = 0; i < cArray2.length; ++i) {
                if (c != cArray2[i]) continue;
                n2 = cArray3[i].length;
                bl = true;
                break;
            }
            n += n2;
        }
        return bl ? n : -1;
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable String string, @Nonnull char[] cArray, @Nonnull char[][] cArray2) {
        if (StringHelper.isEmpty(string)) {
            return CGlobal.EMPTY_CHAR_ARRAY;
        }
        return StringReplace.replaceMultiple(string.toCharArray(), cArray, cArray2);
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable char[] cArray, @Nonnull char[] cArray2, @Nonnull char[][] cArray3) {
        ValueEnforcer.notNull(cArray2, "SearchChars");
        ValueEnforcer.notNull(cArray3, "ReplacementStrings");
        ValueEnforcer.isEqual(cArray2.length, cArray3.length, "array length mismatch");
        if (cArray == null || cArray.length == 0) {
            return CGlobal.EMPTY_CHAR_ARRAY;
        }
        if (cArray2.length == 0) {
            return cArray;
        }
        int n = StringReplace.getReplaceMultipleResultLength(cArray, cArray2, cArray3);
        if (n == -1) {
            return cArray;
        }
        char[] cArray4 = new char[n];
        int n2 = 0;
        for (char c : cArray) {
            boolean bl = false;
            for (int i = 0; i < cArray2.length; ++i) {
                if (c != cArray2[i]) continue;
                char[] cArray5 = cArray3[i];
                int n3 = cArray5.length;
                System.arraycopy(cArray5, 0, cArray4, n2, n3);
                n2 += n3;
                bl = true;
                break;
            }
            if (bl) continue;
            cArray4[n2++] = c;
        }
        return cArray4;
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable String string, @Nonnull char[] cArray, @Nonnull char[][] cArray2, @Nonnull Writer writer) throws IOException {
        if (StringHelper.isEmpty(string)) {
            return 0;
        }
        return StringReplace.replaceMultipleTo(string.toCharArray(), cArray, cArray2, writer);
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable char[] cArray, @Nonnull char[] cArray2, @Nonnull char[][] cArray3, @Nonnull Writer writer) throws IOException {
        return cArray == null ? 0 : StringReplace.replaceMultipleTo(cArray, 0, cArray.length, cArray2, cArray3, writer);
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull char[] cArray2, @Nonnull char[][] cArray3, @Nonnull Writer writer) throws IOException {
        if (cArray != null) {
            ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        }
        ValueEnforcer.notNull(cArray2, "SearchChars");
        ValueEnforcer.notNull(cArray3, "ReplacementStrings");
        ValueEnforcer.isEqual(cArray2.length, cArray3.length, "array length mismatch");
        ValueEnforcer.notNull(writer, "Target");
        if (cArray == null || cArray.length == 0 || n2 == 0) {
            return 0;
        }
        if (cArray2.length == 0) {
            writer.write(cArray, n, n2);
            return 0;
        }
        int n3 = n;
        int n4 = n;
        int n5 = 0;
        int n6 = cArray2.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            for (int j = 0; j < n6; ++j) {
                if (c != cArray2[j]) continue;
                if (n3 < n4) {
                    writer.write(cArray, n3, n4 - n3);
                }
                n3 = n4 + 1;
                writer.write(cArray3[j]);
                ++n5;
                break;
            }
            ++n4;
        }
        if (n3 < n4) {
            writer.write(cArray, n3, n4 - n3);
        }
        return n5;
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable String string, @Nonnull char[] cArray, char c) {
        ValueEnforcer.notNull(cArray, "SearchChars");
        if (StringHelper.isEmpty(string)) {
            return CGlobal.EMPTY_CHAR_ARRAY;
        }
        char[] cArray2 = string.toCharArray();
        if (cArray.length == 0) {
            return cArray2;
        }
        char[] cArray3 = new char[cArray2.length];
        int n = 0;
        for (char c2 : cArray2) {
            cArray3[n] = ArrayHelper.contains(cArray, c2) ? c : c2;
            ++n;
        }
        return cArray3;
    }

    public static void replaceMultipleTo(@Nullable String string, @Nonnull char[] cArray, char c, @Nonnull StringBuilder stringBuilder) {
        ValueEnforcer.notNull(cArray, "SearchChars");
        ValueEnforcer.notNull(stringBuilder, "Target");
        if (StringHelper.isNotEmpty(string)) {
            if (cArray.length == 0) {
                stringBuilder.append(string);
            } else {
                for (char c2 : string.toCharArray()) {
                    if (ArrayHelper.contains(cArray, c2)) {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
    }

    public static void replaceMultipleTo(@Nullable String string, @Nonnull char[] cArray, char c, @Nonnull Writer writer) throws IOException {
        ValueEnforcer.notNull(cArray, "SearchChars");
        ValueEnforcer.notNull(writer, "Target");
        if (StringHelper.isNotEmpty(string)) {
            if (cArray.length == 0) {
                writer.write(string);
            } else {
                for (char c2 : string.toCharArray()) {
                    if (ArrayHelper.contains(cArray, c2)) {
                        writer.write(c);
                        continue;
                    }
                    writer.write(c2);
                }
            }
        }
    }

    @Nonnull
    public static String replaceMultipleAsString(@Nullable String string, @Nonnull char[] cArray, char c) {
        ValueEnforcer.notNull(cArray, "SearchChars");
        if (StringHelper.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringReplace.replaceMultipleTo(string, cArray, c, stringBuilder);
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceMultiple(@Nullable String string, @Nullable Map<String, String> map) {
        if (StringHelper.isEmpty(string) || map == null || map.isEmpty()) {
            return string;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = StringReplace.replaceAll(string2, entry.getKey(), entry.getValue());
        }
        return string2;
    }

    @Nullable
    public static String replaceMultiple(@Nullable String string, @Nullable String[] stringArray, @Nullable String[] stringArray2) {
        int n;
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = n = stringArray2 == null ? 0 : stringArray2.length;
        if (n2 != n) {
            throw new IllegalArgumentException("Array length mismatch!");
        }
        if (n2 == 0) {
            return string;
        }
        String string2 = string;
        for (int i = 0; i < n2; ++i) {
            string2 = StringReplace.replaceAll(string2, stringArray[i], stringArray2[i]);
        }
        return string2;
    }
}

